/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import java.io.Serializable;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.op.ExecuteActivity;
import org.jbpm.pvm.internal.model.op.ExecuteEventListener;
import org.jbpm.pvm.internal.model.op.MoveToParentActivity;
import org.jbpm.pvm.internal.model.op.TransitionEndActivity;
import org.jbpm.pvm.internal.model.op.TransitionStartActivity;
import org.jbpm.pvm.internal.model.op.TransitionTake;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final AtomicOperation EXECUTE_ACTIVITY = new ExecuteActivity();
    public static final AtomicOperation PROPAGATE_TO_PARENT = new MoveToParentActivity();
    public static final AtomicOperation TRANSITION_TAKE = new TransitionTake();
    public static final AtomicOperation TRANSITION_START_ACTIVITY = new TransitionStartActivity();
    public static final AtomicOperation EXECUTE_EVENT_LISTENER = new ExecuteEventListener();
    public static final AtomicOperation TRANSITION_END_ACTIVITY = new TransitionEndActivity();

    public abstract boolean isAsync(ExecutionImpl var1);

    public abstract MessageImpl<?> createAsyncMessage(ExecutionImpl var1);

    public abstract void perform(ExecutionImpl var1);

    public static AtomicOperation parseAtomicOperation(String text) {
        if (text == null) {
            return null;
        }
        if (TRANSITION_END_ACTIVITY.toString().equals(text)) {
            return TRANSITION_END_ACTIVITY;
        }
        if (EXECUTE_EVENT_LISTENER.toString().equals(text)) {
            return EXECUTE_EVENT_LISTENER;
        }
        if (EXECUTE_ACTIVITY.toString().equals(text)) {
            return EXECUTE_ACTIVITY;
        }
        if (TRANSITION_TAKE.toString().equals(text)) {
            return TRANSITION_TAKE;
        }
        if (TRANSITION_START_ACTIVITY.toString().equals(text)) {
            return TRANSITION_START_ACTIVITY;
        }
        if (PROPAGATE_TO_PARENT.toString().equals(text)) {
            return PROPAGATE_TO_PARENT;
        }
        throw new JbpmException("invalid atomic operation text: " + text);
    }
}

