/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import org.jbpm.api.listener.EventListener;
import org.jbpm.pvm.internal.model.Continuation;
import org.jbpm.pvm.internal.model.ProcessElementImpl;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.internal.wire.Descriptor;

public class EventListenerReference
extends ProcessElementImpl {
    private static final long serialVersionUID = 1L;
    protected EventListener eventListener;
    protected boolean isEventListenerStateful = false;
    protected Descriptor eventListenerDescriptor;
    protected boolean isPropagationEnabled = false;
    protected Continuation continuation = Continuation.SYNCHRONOUS;

    public boolean isPropagationEnabled() {
        return this.isPropagationEnabled;
    }

    public void setPropagationEnabled(boolean isPropagationEnabled) {
        this.isPropagationEnabled = isPropagationEnabled;
    }

    public boolean isAsync() {
        return Continuation.SYNCHRONOUS != this.continuation;
    }

    public EventListener getEventListener() {
        if (this.eventListener != null) {
            return this.eventListener;
        }
        if (this.eventListenerDescriptor != null) {
            EventListener createdEventListener = (EventListener)ReflectUtil.instantiateUserCode(this.eventListenerDescriptor, this.processDefinition);
            if (!this.isEventListenerStateful) {
                this.eventListener = createdEventListener;
            }
            return createdEventListener;
        }
        return null;
    }

    public Continuation getContinuation() {
        return this.continuation;
    }

    public void setContinuation(Continuation continuation) {
        this.continuation = continuation;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public boolean isEventListenerStateful() {
        return this.isEventListenerStateful;
    }

    public void setEventListenerStateful(boolean isEventListenerStateful) {
        this.isEventListenerStateful = isEventListenerStateful;
    }

    public Descriptor getEventListenerDescriptor() {
        return this.eventListenerDescriptor;
    }

    public void setEventListenerDescriptor(Descriptor eventListenerDescriptor) {
        this.eventListenerDescriptor = eventListenerDescriptor;
    }
}

