/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.migration;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.Execution;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.migration.MigrationDescriptor;
import org.jbpm.pvm.internal.migration.MigrationHandler;
import org.jbpm.pvm.internal.session.RepositorySession;
import org.jbpm.pvm.internal.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceMigrator {
    private static Log log = Log.getLog((String)InstanceMigrator.class.getName());

    public static void migrateAll(ProcessDefinition processDefinition, MigrationDescriptor migrationDescriptor) {
        List<ProcessInstance> processInstances = InstanceMigrator.getProcessInstancesToMigrate(processDefinition.getName(), migrationDescriptor);
        for (ProcessInstance processInstance : processInstances) {
            InstanceMigrator.migrateInstance(processDefinition, processInstance, migrationDescriptor);
        }
    }

    public static void migrateInstance(ProcessDefinition processDefinition, ProcessInstance processInstance, MigrationDescriptor migrationDescriptor) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String className : migrationDescriptor.getMigrationHandlerClassNames()) {
            try {
                Class<?> clazz = classLoader.loadClass(className);
                MigrationHandler handler = (MigrationHandler)ReflectUtil.newInstance(clazz);
                handler.migrateInstance(processDefinition, processInstance, migrationDescriptor);
            }
            catch (ClassNotFoundException e) {
                log.error("Class " + className + " not found on the classpath.", (Throwable)e);
            }
        }
    }

    private static void migrateExecutions(ProcessDefinition processDefinition, Execution execution, MigrationDescriptor migrationDescriptor) {
        InstanceMigrator.migrateChildExecutions(processDefinition, execution, migrationDescriptor);
    }

    private static void migrateChildExecutions(ProcessDefinition processDefinition, Execution execution, MigrationDescriptor migrationDescriptor) {
        for (Execution child : execution.getExecutions()) {
            InstanceMigrator.migrateExecutions(processDefinition, child, migrationDescriptor);
        }
    }

    private static List<ProcessInstance> getProcessInstancesToMigrate(String processDefinitionName, MigrationDescriptor migrationDescriptor) {
        ArrayList<ProcessInstance> result = new ArrayList<ProcessInstance>();
        ExecutionService executionService = EnvironmentImpl.getFromCurrent(ExecutionService.class);
        List<ProcessDefinition> processesToMigrate = InstanceMigrator.getProcessesToMigrate(processDefinitionName, migrationDescriptor);
        for (ProcessDefinition processDefinition : processesToMigrate) {
            result.addAll(executionService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).list());
        }
        return result;
    }

    private static List<ProcessDefinition> getProcessesToMigrate(String processDefinitionName, MigrationDescriptor migrationDescriptor) {
        int endIndex;
        RepositorySession repositorySession = EnvironmentImpl.getFromCurrent(RepositorySession.class);
        List processDefinitions = repositorySession.createProcessDefinitionQuery().processDefinitionName(processDefinitionName).orderAsc("versionProperty.longValue").list();
        int startIndex = InstanceMigrator.calculateStartIndex(processDefinitions.size() - 1, migrationDescriptor);
        if (startIndex > (endIndex = InstanceMigrator.calculateEndIndex(processDefinitions.size() - 1, migrationDescriptor))) {
            startIndex = endIndex;
        }
        return processDefinitions.subList(startIndex, endIndex);
    }

    private static int calculateStartIndex(int max, MigrationDescriptor migrationDescriptor) {
        int result = max - 1;
        if (migrationDescriptor.getStartVersion() != -1) {
            result = migrationDescriptor.getStartVersion() - 1;
        } else if (migrationDescriptor.getStartOffset() != -1) {
            result = max - migrationDescriptor.getStartOffset();
        }
        if (result < 0) {
            result = 0;
        }
        if (result > max - 1) {
            result = max - 1;
        }
        return result;
    }

    private static int calculateEndIndex(int max, MigrationDescriptor migrationDescriptor) {
        int result = max;
        if (migrationDescriptor.getEndVersion() != -1) {
            result = migrationDescriptor.getEndVersion();
        } else if (migrationDescriptor.getEndOffset() != -1) {
            result = max - migrationDescriptor.getEndOffset() + 1;
        }
        if (result < 1) {
            result = 1;
        }
        if (result > max - 1) {
            result = max;
        }
        return result;
    }
}

