/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.job;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.job.Timer;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cal.BusinessCalendar;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.id.DbidGenerator;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.jobexecutor.JobAddedNotification;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.script.ScriptManager;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.session.TimerSession;
import org.jbpm.pvm.internal.tx.Transaction;
import org.jbpm.pvm.internal.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerImpl
extends JobImpl<Boolean>
implements Timer {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)TimerImpl.class.getName());
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss,SSS";
    protected String signalName;
    protected String eventName;
    protected String repeat;
    public static final String EVENT_TIMER = "timer";

    public void schedule() {
        this.dbid = DbidGenerator.getDbidGenerator().getNextId();
        TimerSession timerSession = EnvironmentImpl.getFromCurrent(TimerSession.class);
        timerSession.schedule(this);
    }

    public void setDueDateDescription(String dueDateDescription) {
        ScriptManager scriptManager = ScriptManager.getScriptManager();
        dueDateDescription = (String)scriptManager.evaluateExpression(dueDateDescription, null);
        Date now = Clock.getCurrentTime();
        BusinessCalendar businessCalendar = EnvironmentImpl.getFromCurrent(BusinessCalendar.class);
        this.duedate = businessCalendar.add(now, dueDateDescription);
    }

    public Boolean execute(Environment environment) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("executing " + this);
        }
        if (environment == null) {
            throw new JbpmException("environment is null");
        }
        if (this.signalName != null) {
            if (log.isDebugEnabled()) {
                log.debug("feeding timer signal " + this.signalName + " into " + this.execution);
            }
            this.execution.signal(this.signalName);
        }
        if (this.eventName != null) {
            ActivityImpl eventSource = this.execution.getActivity();
            if (log.isDebugEnabled()) {
                log.debug("firing event " + this.signalName + " into " + eventSource);
            }
            this.execution.fire(this.eventName, eventSource);
        }
        boolean deleteThisJob = true;
        if (this.repeat == null) {
            DbSession dbSession;
            if (log.isDebugEnabled()) {
                log.debug("deleting " + this);
            }
            if ((dbSession = (DbSession)environment.get(DbSession.class)) == null) {
                throw new JbpmException("no " + DbSession.class.getName() + " in environment");
            }
            dbSession.delete(this);
        } else {
            deleteThisJob = false;
            do {
                this.setDueDateDescription(this.repeat);
            } while (this.duedate.getTime() <= Clock.getCurrentTime().getTime());
            if (log.isDebugEnabled()) {
                log.debug("rescheduled " + this + " for " + TimerImpl.formatDueDate(this.duedate));
            }
            this.release();
            JobExecutor jobExecutor = (JobExecutor)environment.get(JobExecutor.class);
            if (jobExecutor != null) {
                Transaction transaction = (Transaction)environment.get(Transaction.class);
                if (transaction == null) {
                    throw new JbpmException("no transaction in environment");
                }
                JobAddedNotification jobNotificator = new JobAddedNotification(jobExecutor);
                transaction.registerSynchronization(jobNotificator);
            }
        }
        return deleteThisJob;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("timer[");
        text.append(this.dbid);
        if (this.duedate != null) {
            text.append("|");
            text.append(TimerImpl.formatDueDate(this.duedate));
        }
        if (this.signalName != null) {
            text.append("|");
            text.append(this.signalName);
        }
        if (this.eventName != null) {
            text.append("|");
            text.append(this.eventName);
        }
        text.append("]");
        return text.toString();
    }

    public static String formatDueDate(Date date) {
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }
}

