/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.identity.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.identity.idm.api.Attribute;
import org.jboss.identity.idm.api.AttributesManager;
import org.jboss.identity.idm.api.IdentitySearchCriteria;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.RoleType;
import org.jboss.identity.idm.common.exception.FeatureNotSupportedException;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.api.SimpleAttribute;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jbpm.api.JbpmException;
import org.jbpm.api.identity.Group;
import org.jbpm.api.identity.User;
import org.jbpm.pvm.internal.identity.impl.GroupImpl;
import org.jbpm.pvm.internal.identity.impl.UserImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossIdmIdentitySessionImpl
implements org.jbpm.pvm.internal.identity.spi.IdentitySession {
    protected IdentitySession identitySession;
    public String DEFAULT_JBPM_MEMBER_ROLE = "default_jBPM_member_role";
    public String DEFAUL_JBPM_GROUP_TYPE = "default_jBPM_Group_Type";

    public JBossIdmIdentitySessionImpl(IdentitySession identitySession) {
        this.identitySession = identitySession;
    }

    @Override
    public String createUser(String userName, String givenName, String familyName, String businessEmail) {
        try {
            org.jboss.identity.idm.api.User idUser = this.identitySession.getPersistenceManager().createUser(userName);
            ArrayList<SimpleAttribute> attrs = new ArrayList<SimpleAttribute>();
            if (givenName != null) {
                attrs.add(new SimpleAttribute("user.name.given", (Object)givenName));
            }
            if (familyName != null) {
                attrs.add(new SimpleAttribute("user.name.family", (Object)familyName));
            }
            if (businessEmail != null) {
                attrs.add(new SimpleAttribute("user.business-info.online.email", (Object)businessEmail));
            }
            this.identitySession.getAttributesManager().addAttributes((IdentityType)idUser, attrs.toArray(new Attribute[attrs.size()]));
            return idUser.getId();
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't create user " + userName, (Throwable)e);
        }
    }

    @Override
    public List<User> findUsers() {
        try {
            Collection idUsers = this.identitySession.getPersistenceManager().findUser((IdentitySearchCriteria)null);
            ArrayList<User> users = new ArrayList<User>();
            for (org.jboss.identity.idm.api.User idUser : idUsers) {
                users.add(this.getUserInfo(idUser));
            }
            return users;
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't get users from identity component", (Throwable)e);
        }
    }

    @Override
    public User findUserById(String userId) {
        try {
            org.jboss.identity.idm.api.User idUser = this.identitySession.getPersistenceManager().findUser(userId);
            if (idUser != null) {
                return this.getUserInfo(idUser);
            }
            return null;
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't get user from id of " + userId, (Throwable)e);
        }
    }

    private User getUserInfo(org.jboss.identity.idm.api.User idUser) throws IdentityException {
        String name = idUser.getId();
        String givenName = this.getAttributeString(idUser, "user.name.given");
        String familyName = this.getAttributeString(idUser, "user.name.family");
        String businessEmail = this.getAttributeString(idUser, "user.business-info.online.email");
        UserImpl user = new UserImpl(name, givenName, familyName);
        user.setBusinessEmail(businessEmail);
        return user;
    }

    @Override
    public List<User> findUsersById(String ... userIds) {
        ArrayList<User> users = new ArrayList<User>();
        for (String userId : userIds) {
            User user = this.findUserById(userId);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    public List<User> findUsersByGroup(String groupId) {
        try {
            ArrayList<User> users = new ArrayList<User>();
            org.jboss.identity.idm.api.Group idGroup = this.findIdmGroupByIdmGroupId(this.convertjbpmGroupId2IdmGroupId(groupId));
            if (idGroup == null) {
                return users;
            }
            Collection idusers = this.identitySession.getRoleManager().findUsersWithRelatedRole(idGroup, null);
            for (org.jboss.identity.idm.api.User iduser : idusers) {
                users.add(this.findUserById(iduser.getId()));
            }
            return users;
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't find users by groupid: " + groupId, (Throwable)e);
        }
        catch (FeatureNotSupportedException e) {
            throw new JbpmException("couldn't find users by groupid: " + groupId, (Throwable)e);
        }
    }

    @Override
    public void deleteUser(String userName) {
        try {
            this.identitySession.getPersistenceManager().removeUser(userName, true);
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't delete user [" + userName + "]", (Throwable)e);
        }
    }

    @Override
    public String createGroup(String groupName, String groupType, String parentGroupId) {
        try {
            String gtype = groupType;
            if (gtype == null) {
                gtype = this.DEFAUL_JBPM_GROUP_TYPE;
            }
            org.jboss.identity.idm.api.Group group = this.identitySession.getPersistenceManager().createGroup(groupName, gtype);
            String groupId = group.getId();
            if (parentGroupId != null) {
                org.jboss.identity.idm.api.Group parentGroup = this.findIdmGroupByIdmGroupId(this.convertjbpmGroupId2IdmGroupId(parentGroupId));
                if (parentGroup == null) {
                    throw new JbpmException("parent group " + parentGroupId + " doesn't exist");
                }
                this.identitySession.getRelationshipManager().associateGroups(parentGroup, group);
            }
            return this.convertIdmGroupId2jbpmGroupId(groupId);
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't create group " + groupName, (Throwable)e);
        }
    }

    @Override
    public Group findGroupById(String groupId) {
        try {
            org.jboss.identity.idm.api.Group idGroup = this.findIdmGroupByIdmGroupId(this.convertjbpmGroupId2IdmGroupId(groupId));
            if (idGroup == null) {
                return null;
            }
            GroupImpl group = new GroupImpl();
            group.setId(this.convertIdmGroupId2jbpmGroupId(idGroup.getId()));
            group.setType(idGroup.getGroupType());
            group.setName(idGroup.getName());
            Collection idParentGroups = this.identitySession.getRelationshipManager().findAssociatedGroups(idGroup, null, false, false);
            if (idParentGroups.size() > 0) {
                org.jboss.identity.idm.api.Group idParent = (org.jboss.identity.idm.api.Group)idParentGroups.iterator().next();
                GroupImpl parentGroup = new GroupImpl();
                parentGroup.setId(this.convertIdmGroupId2jbpmGroupId(idParent.getId()));
                parentGroup.setType(idParent.getGroupType());
                parentGroup.setName(idParent.getName());
                group.setParent(parentGroup);
            }
            return group;
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't find group by id [" + groupId + "]", (Throwable)e);
        }
    }

    public List<Group> findGroupsByGroupType(String groupType) {
        try {
            Collection idGroups = this.identitySession.getPersistenceManager().findGroup(groupType);
            ArrayList<Group> groups = new ArrayList<Group>();
            for (org.jboss.identity.idm.api.Group idGroup : idGroups) {
                groups.add(this.findGroupById(this.convertIdmGroupId2jbpmGroupId(idGroup.getId())));
            }
            return groups;
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't get groups from identity component, groupType [" + groupType + "]", (Throwable)e);
        }
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        try {
            Collection idGroups = this.identitySession.getRoleManager().findGroupsWithRelatedRole(userId, null);
            ArrayList<Group> groups = new ArrayList<Group>();
            for (org.jboss.identity.idm.api.Group idGroup : idGroups) {
                groups.add(this.findGroupById(this.convertIdmGroupId2jbpmGroupId(idGroup.getId())));
            }
            return groups;
        }
        catch (Exception e) {
            throw new JbpmException("Couldn't get Groups by userId [" + userId + "]", (Throwable)e);
        }
    }

    @Override
    public List<Group> findGroupsByUserAndGroupType(String userName, String groupType) {
        try {
            org.jboss.identity.idm.api.User idUser = this.identitySession.getPersistenceManager().findUser(userName);
            Collection idGroups = this.identitySession.getRoleManager().findGroupsWithRelatedRole(idUser, groupType, null);
            ArrayList<Group> groups = new ArrayList<Group>();
            for (org.jboss.identity.idm.api.Group idGroup : idGroups) {
                groups.add(this.findGroupById(this.convertIdmGroupId2jbpmGroupId(idGroup.getId())));
            }
            return groups;
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get groups for user " + userName + " and groupType " + groupType, (Throwable)e);
        }
    }

    @Override
    public void deleteGroup(String groupId) {
        try {
            org.jboss.identity.idm.api.Group group = this.findIdmGroupByIdmGroupId(this.convertjbpmGroupId2IdmGroupId(groupId));
            if (group == null) {
                return;
            }
            this.identitySession.getPersistenceManager().removeGroup(group, true);
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't delete group " + groupId, (Throwable)e);
        }
    }

    @Override
    public void createMembership(String userId, String groupId, String role) {
        try {
            org.jboss.identity.idm.api.Group group = this.findIdmGroupByIdmGroupId(this.convertjbpmGroupId2IdmGroupId(groupId));
            if (group == null) {
                throw new JbpmException("group " + groupId + " doesn't exist");
            }
            org.jboss.identity.idm.api.User idUser = this.identitySession.getPersistenceManager().findUser(userId);
            if (idUser == null) {
                throw new JbpmException("user " + userId + " doesn't exist");
            }
            if (role == null) {
                role = this.DEFAULT_JBPM_MEMBER_ROLE;
            }
            RoleType roleType = this.identitySession.getRoleManager().getRoleType(role);
            System.out.println("The Role Type is: " + roleType);
            if (roleType == null) {
                roleType = this.identitySession.getRoleManager().createRoleType(role);
            }
            this.identitySession.getRoleManager().createRole(roleType, idUser, group);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't create membership " + userId + ", " + groupId + ", " + role, (Throwable)e);
        }
    }

    @Override
    public void deleteMembership(String userId, String groupId, String role) {
        try {
            RoleType rtype = this.identitySession.getRoleManager().getRoleType(role);
            this.identitySession.getRoleManager().removeRole(rtype.getName(), userId, this.convertjbpmGroupId2IdmGroupId(groupId));
        }
        catch (Exception e) {
            throw new JbpmException("couldn't delete the membership [" + userId + "," + groupId + "," + role + "]", (Throwable)e);
        }
    }

    protected org.jboss.identity.idm.api.Group findIdmGroupByIdmGroupId(String groupId) {
        try {
            return this.identitySession.getPersistenceManager().findGroupById(groupId);
        }
        catch (IdentityException e) {
            throw new JbpmException("couldn't find the group by groupId: " + groupId, (Throwable)e);
        }
    }

    protected String getAttributeString(org.jboss.identity.idm.api.User idUser, String attributeName) throws IdentityException {
        return this.getAttributeString(idUser, null, attributeName);
    }

    protected String getAttributeString(org.jboss.identity.idm.api.Group idGroup, String attributeName) throws IdentityException {
        return this.getAttributeString(null, idGroup, attributeName);
    }

    protected String getAttributeString(org.jboss.identity.idm.api.User idUser, org.jboss.identity.idm.api.Group idGroup, String attributeName) throws IdentityException {
        AttributesManager attributesManager = this.identitySession.getAttributesManager();
        Attribute attribute = null;
        attribute = idUser != null ? attributesManager.getAttribute((IdentityType)idUser, attributeName) : attributesManager.getAttribute((IdentityType)idGroup, attributeName);
        if (attribute != null) {
            return (String)attribute.getValue();
        }
        return null;
    }

    private String convertIdmGroupId2jbpmGroupId(String groupId) {
        GroupId theGroupId = new GroupId(groupId);
        if (this.DEFAUL_JBPM_GROUP_TYPE.equals(theGroupId.getType()) || theGroupId.getType() == null) {
            return theGroupId.getName();
        }
        return theGroupId.getType() + "." + theGroupId.getName();
    }

    private String convertjbpmGroupId2IdmGroupId(String jbpmGroupId) {
        StringTokenizer st = new StringTokenizer(jbpmGroupId, ".");
        String type = this.DEFAUL_JBPM_GROUP_TYPE;
        if (st.countTokens() > 1) {
            type = st.nextToken();
        }
        String name = st.nextToken();
        return new GroupId(name, type).getId();
    }

    public IdentitySession getIdentitySession() {
        return this.identitySession;
    }

    public void setIdentitySession(IdentitySession identitySession) {
        this.identitySession = identitySession;
    }
}

