/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.Date;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.job.Job;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.env.JobContext;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.jobexecutor.JobExceptionHandler;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.tx.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteJobCmd
extends AbstractCommand<Job> {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)ExecuteJobCmd.class.getName());
    protected Long jobDbid;

    public ExecuteJobCmd(String jobId) {
        if (jobId == null) {
            throw new JbpmException("jobId is null");
        }
        this.jobDbid = Long.parseLong(jobId);
    }

    public ExecuteJobCmd(Long jobDbid) {
        this.jobDbid = jobDbid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Job execute(Environment environmentInterface) throws Exception {
        EnvironmentImpl environment = (EnvironmentImpl)environmentInterface;
        DbSession dbSession = environment.get(DbSession.class);
        if (dbSession == null) {
            throw new JbpmException("no db-session configured");
        }
        JobImpl job = dbSession.get(JobImpl.class, this.jobDbid);
        if (job != null) {
            JobContext jobContext = new JobContext(job);
            environment.setContext(jobContext);
            try {
                log.debug("executing job " + job + "...");
                job.execute(environment);
                log.debug("executed job " + job);
                Date lockExpirationDate = job.getLockExpirationTime();
                if (lockExpirationDate == null) return job;
                long lockExpiration = lockExpirationDate.getTime();
                long currentTime = System.currentTimeMillis();
                if (currentTime <= lockExpiration) return job;
                throw new JbpmException("job took too long: lock expired " + (currentTime - lockExpiration) + "ms ago");
            }
            catch (Exception exception) {
                log.error("exception while executing '" + job + "'", (Throwable)exception);
                this.handleJobExecutionException(environment, job, exception);
                return job;
            }
            finally {
                environment.removeContext(jobContext);
            }
        } else {
            log.debug("job " + this.jobDbid + " no longer exists");
        }
        return job;
    }

    protected void handleJobExecutionException(Environment environment, JobImpl<?> job, Exception exception) {
        Transaction transaction = (Transaction)environment.get(Transaction.class);
        CommandService commandService = (CommandService)environment.get("newTxRequiredCommandService");
        JobExceptionHandler jobExceptionHandler = new JobExceptionHandler(job.getDbid(), exception, commandService);
        transaction.registerSynchronization(jobExceptionHandler);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new JbpmException("job failed: " + exception.getMessage(), (Throwable)exception);
    }
}

