/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cfg;

import org.jbpm.pvm.internal.cfg.ConfigurationImpl;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationParser
extends Parser {
    private static final long serialVersionUID = 1L;
    Parser processEngineContextParser = new WireParser();
    Parser transactionContextParser = new WireParser();
    protected static ConfigurationParser INSTANCE = new ConfigurationParser();

    public static ConfigurationParser getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseDocument(Document document, Parse parse) {
        Element txCtxElement;
        String jndiName;
        Element documentElement = document.getDocumentElement();
        ConfigurationImpl configuration = parse.contextStackFind(ConfigurationImpl.class);
        String spring = XmlUtil.attribute(documentElement, "spring");
        if ("enabled".equals(spring)) {
            configuration.springEnabled();
        }
        if ((jndiName = XmlUtil.attribute(documentElement, "jndi-name")) != null) {
            if (configuration.getJndiName() != null && !jndiName.equals(configuration.getJndiName())) {
                parse.addProblem("duplicate jndi name specification: " + jndiName + " != " + configuration.getJndiName());
            } else {
                configuration.jndi(jndiName);
            }
        }
        for (Element importElement : XmlUtil.elements(documentElement, "import")) {
            if (!importElement.hasAttribute("resource")) continue;
            String resource = importElement.getAttribute("resource");
            Parse importParse = this.createParse().setResource(resource).contextStackPush((Object)configuration).propagateContexMap(parse).execute();
            parse.addProblems(importParse.getProblems());
        }
        Element processEngineElement = XmlUtil.element(documentElement, "process-engine-context");
        if (processEngineElement != null) {
            WireDefinition processEngineContextDefinition = configuration.getProcessEngineWireContext().getWireDefinition();
            parse.contextStackPush(processEngineContextDefinition);
            try {
                this.processEngineContextParser.parseDocumentElement(processEngineElement, parse);
            }
            finally {
                parse.contextStackPop();
            }
        }
        if ((txCtxElement = XmlUtil.element(documentElement, "transaction-context")) != null) {
            WireDefinition transactionContextDefinition = configuration.getTransactionWireDefinition();
            parse.contextStackPush(transactionContextDefinition);
            try {
                this.transactionContextParser.parseDocumentElement(txCtxElement, parse);
            }
            finally {
                parse.contextStackPop();
            }
        }
        parse.setDocumentObject((Object)configuration);
        return configuration;
    }

    public Parser getProcessEngineContextParser() {
        return this.processEngineContextParser;
    }

    public void setProcessEngineContextParser(Parser applicationWireXmlParser) {
        this.processEngineContextParser = applicationWireXmlParser;
    }

    public Parser getTransactionContextParser() {
        return this.transactionContextParser;
    }

    public void setTransactionContextParser(Parser blockWireXmlParser) {
        this.transactionContextParser = blockWireXmlParser;
    }
}

