/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.ant;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.RepositoryService;
import org.jbpm.pvm.internal.ant.AntHelper;

public class JbpmDeployTask
extends MatchingTask {
    String jbpmCfg = null;
    File file = null;
    List fileSets = new ArrayList();
    boolean failOnError = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(JbpmDeployTask.class.getClassLoader());
        try {
            ProcessEngine processEngine = AntHelper.getProcessEngine(this.jbpmCfg);
            if (this.file != null) {
                this.deployFile(processEngine, this.file);
            }
            for (FileSet fileSet : this.fileSets) {
                DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.getProject());
                File baseDir = dirScanner.getBasedir();
                String[] includedFiles = dirScanner.getIncludedFiles();
                List<String> excludedFiles = Arrays.asList(dirScanner.getExcludedFiles());
                for (int i = 0; i < includedFiles.length; ++i) {
                    String fileName = includedFiles[i];
                    if (excludedFiles.contains(fileName)) continue;
                    File file = new File(baseDir, fileName);
                    this.deployFile(processEngine, file);
                }
            }
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    protected void deployFile(ProcessEngine processEngine, File processFile) {
        RepositoryService repositoryService = processEngine.getRepositoryService();
        NewDeployment deployment = repositoryService.createDeployment();
        deployment.setName(processFile.getName());
        deployment.setTimestamp(System.currentTimeMillis());
        if (processFile.getName().endsWith(".xml")) {
            this.log("deploying process file " + processFile.getName());
            deployment.addResourceFromFile(processFile);
        } else if (processFile.getName().endsWith("ar")) {
            this.log("deploying business archive " + processFile.getName());
            try {
                FileInputStream fileInputStream = new FileInputStream(processFile);
                ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
                deployment.addResourcesFromZipInputStream(zipInputStream);
            }
            catch (Exception e) {
                throw new BuildException("couldn't read business archive " + processFile, (Throwable)e);
            }
        } else {
            throw new BuildException("unsupported extension: " + processFile + "  Only .xml files and .*ar archives are supported");
        }
        deployment.deploy();
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setJbpmCfg(String jbpmCfg) {
        this.jbpmCfg = jbpmCfg;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

