/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.invocation;

import javax.xml.ws.WebServiceContext;
import org.jboss.ws.common.injection.InjectionHelper;
import org.jboss.ws.common.injection.PreDestroyHolder;
import org.jboss.ws.common.injection.ThreadLocalAwareWebServiceContext;
import org.jboss.ws.common.invocation.AbstractInvocationHandlerJSE;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Reference;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;

public final class InvocationHandlerJAXWS
extends AbstractInvocationHandlerJSE {
    @Override
    public void onEndpointInstantiated(Endpoint endpoint, Invocation invocation) {
        Object _targetBean = this.getTargetBean(invocation);
        Reference reference = endpoint.getInstanceProvider().getInstance(_targetBean.getClass().getName());
        Object targetBean = reference.getValue();
        InjectionHelper.injectWebServiceContext(targetBean, ThreadLocalAwareWebServiceContext.getInstance());
        if (!reference.isInitialized()) {
            this.log.debug((Object)("Calling postConstruct method on JAXWS JSE endpoint: " + targetBean));
            InjectionHelper.callPostConstructMethod(targetBean);
            reference.setInitialized();
        }
        endpoint.addAttachment(PreDestroyHolder.class, (Object)new PreDestroyHolder(targetBean));
    }

    @Override
    public void onBeforeInvocation(Invocation invocation) {
        WebServiceContext wsContext = this.getWebServiceContext(invocation);
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(wsContext);
    }

    @Override
    public void onAfterInvocation(Invocation invocation) {
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(null);
    }

    private WebServiceContext getWebServiceContext(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return (WebServiceContext)invocationContext.getAttachment(WebServiceContext.class);
    }

    private Object getTargetBean(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return invocationContext.getTargetBean();
    }
}

