/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader.cache;

import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.interceptor.reader.ClassMetadataInterceptorReference;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.reader.ReflectiveClassMetadata;
import org.jboss.weld.interceptor.reader.cache.MetadataCachingReader;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMetadataCachingReader
implements MetadataCachingReader {
    private final ConcurrentMap<InterceptorReference<?>, InterceptorMetadata<?>> interceptorMetadataCache = new MapMaker().makeComputingMap(new Function<InterceptorReference<?>, InterceptorMetadata<?>>(){

        @Override
        public InterceptorMetadata<?> apply(InterceptorReference<?> from) {
            return InterceptorMetadataUtils.readMetadataForInterceptorClass(from);
        }
    });
    private final ConcurrentMap<ClassMetadata<?>, InterceptorMetadata<?>> classMetadataInterceptorMetadataCache = new MapMaker().makeComputingMap(new Function<ClassMetadata<?>, InterceptorMetadata<?>>(){

        @Override
        public InterceptorMetadata<?> apply(ClassMetadata<?> from) {
            return InterceptorMetadataUtils.readMetadataForTargetClass(from);
        }
    });
    private final ConcurrentMap<Class<?>, ClassMetadata<?>> reflectiveClassMetadataCache = new MapMaker().makeComputingMap(new Function<Class<?>, ClassMetadata<?>>(){

        @Override
        public ClassMetadata<?> apply(Class<?> from) {
            return ReflectiveClassMetadata.of(from);
        }
    });
    private boolean unwrapRuntimeExceptions = true;

    public void setUnwrapRuntimeExceptions(boolean unwrapRuntimeExceptions) {
        this.unwrapRuntimeExceptions = unwrapRuntimeExceptions;
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(InterceptorReference<T> interceptorReference) {
        try {
            return (InterceptorMetadata)this.interceptorMetadataCache.get(interceptorReference);
        }
        catch (ComputationException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> InterceptorMetadata<T> getTargetClassInterceptorMetadata(ClassMetadata<T> classMetadata) {
        try {
            return (InterceptorMetadata)this.classMetadataInterceptorMetadataCache.get(classMetadata);
        }
        catch (ComputationException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(Class<T> clazz) {
        try {
            return (InterceptorMetadata)this.interceptorMetadataCache.get(ClassMetadataInterceptorReference.of((ClassMetadata)this.reflectiveClassMetadataCache.get(clazz)));
        }
        catch (ComputationException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> ClassMetadata<T> getClassMetadata(Class<T> clazz) {
        try {
            return (ClassMetadata)this.reflectiveClassMetadataCache.get(clazz);
        }
        catch (ComputationException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }
}

