/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.Collection;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenManagerBuilder;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenResolutionFilterWrap;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepositorySystem {
    private final RepositorySystem system = this.getRepositorySystem();

    public RepositorySystemSession getSession(Settings settings) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        MavenManagerBuilder builder = new MavenManagerBuilder(this.system, settings);
        session.setLocalRepositoryManager(builder.localRepositoryManager());
        session.setWorkspaceReader(builder.workspaceReader());
        session.setTransferListener(builder.transferListerer());
        session.setRepositoryListener(builder.repositoryListener());
        session.setOffline(settings.isOffline());
        session.setMirrorSelector(builder.mirrorSelector());
        session.setProxySelector(builder.proxySelector());
        return session;
    }

    public Collection<ArtifactResult> resolveDependencies(RepositorySystemSession session, CollectRequest request, MavenResolutionFilter filter) throws DependencyResolutionException {
        DependencyRequest depRequest = new DependencyRequest(request, (DependencyFilter)new MavenResolutionFilterWrap(filter));
        DependencyResult result = this.system.resolveDependencies(session, depRequest);
        return result.getArtifactResults();
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.system.resolveArtifact(session, request);
    }

    private RepositorySystem getRepositorySystem() {
        try {
            return (RepositorySystem)new DefaultPlexusContainer().lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Unable to lookup component RepositorySystem, cannot establish Aether dependency resolver.", e);
        }
        catch (PlexusContainerException e) {
            throw new RuntimeException("Unable to load RepositorySystem component by Plexus, cannot establish Aether dependency resolver.", e);
        }
    }
}

