/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.jboss.shrinkwrap.resolver.api.ResolverEntryPoint;
import org.jboss.shrinkwrap.resolver.api.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResolverEntryPointInstantiator {
    private static final String MAPPING_LOCATION = "META-INF/services/";
    private static final String KEY_IMPL_CLASS_NAME = "implClass";

    private ResolverEntryPointInstantiator() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static <T extends ResolverEntryPoint<T>> T createFromUserView(Class<T> userViewClass) throws IllegalArgumentException {
        ResolverEntryPoint dependencyType;
        Constructor<T> ctor;
        Class<T> implClass = ResolverEntryPointInstantiator.getImplClassForUserView(userViewClass);
        try {
            ctor = SecurityActions.getConstructor(implClass, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(implClass + " must contain a public no args contructor");
        }
        try {
            dependencyType = (ResolverEntryPoint)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new descriptor instance", e);
        }
        return (T)((ResolverEntryPoint)userViewClass.cast(dependencyType));
    }

    private static <T extends ResolverEntryPoint<T>> Class<T> getImplClassForUserView(Class<?> userViewClass) throws IllegalArgumentException {
        Class<T> implClass;
        if (userViewClass == null) {
            throw new IllegalArgumentException("User view class must be specified");
        }
        String className = userViewClass.getName();
        String resourceName = MAPPING_LOCATION + className;
        ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
        InputStream resourceStream = tccl.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new IllegalArgumentException("No resource " + resourceName + " was found configured for user view class " + userViewClass.getName());
        }
        Properties props = new Properties();
        try {
            props.load(resourceStream);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O Problem in reading the properties for " + userViewClass.getName(), e);
        }
        String implClassName = props.getProperty(KEY_IMPL_CLASS_NAME);
        if (implClassName == null || implClassName.length() == 0) {
            throw new IllegalStateException("Resource " + resourceName + " for " + userViewClass + " does not contain key " + KEY_IMPL_CLASS_NAME);
        }
        try {
            implClass = ResolverEntryPointInstantiator.getImplClassForName(tccl, implClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load specified implementation class from " + tccl + ": " + implClassName, e);
        }
        return implClass;
    }

    private static <T extends ResolverEntryPoint<T>> Class<T> getImplClassForName(ClassLoader cl, String implClassName) throws ClassNotFoundException {
        assert (cl != null) : "CL is required";
        assert (implClassName != null && implClassName.length() > 0) : "Impl Class name is required";
        return Class.forName(implClassName, false, cl);
    }
}

