/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven;

import org.jboss.shrinkwrap.resolver.api.maven.EffectivePomMavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenConfigurationType;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.SecurityActions;
import org.jboss.shrinkwrap.resolver.api.maven.Validate;

public class MavenConfigurationTypes {
    public static final MavenConfigurationType<MavenDependencyResolver> MANUAL = new MavenConfigurationType<MavenDependencyResolver>(){

        @Override
        public MavenDependencyResolver configure(MavenDependencyResolver resolver) {
            return resolver;
        }
    };
    public static final MavenConfigurationType<EffectivePomMavenDependencyResolver> ENVIRONMENT = new MavenConfigurationType<EffectivePomMavenDependencyResolver>(){
        public static final String POM_FILE_KEY = "maven.execution.pom-file";
        public static final String OFFLINE_KEY = "maven.execution.offline";
        public static final String USER_SETTINGS_KEY = "maven.execution.user-settings";
        public static final String GLOBAL_SETTINGS_KEY = "maven.execution.global-settings";
        public static final String ACTIVE_PROFILES_KEY = "maven.execution.active-profiles";
        private static final String CONSTRUCTION_EXCEPTION = "Configuration from environment requires that user has following properties set, however they were not detected in runtime environment:\n\tmaven.execution.pom-file\n\tmaven.execution.offline\n\tmaven.execution.user-settings\n\tmaven.execution.global-settings\n\tmaven.execution.active-profiles\n\nYou should enable ShrinkWrap Maven Resolver to get them set for you automatically if executing from Maven via adding following to your <build> section:\n\n<plugin>\n\t<groupId>org.jboss.shrinkwrap.resolver</groupId>\n\t<artifactId>resolver-maven-plugin</artifactId>\n\t<executions>\n\t\t<execution>\n\t\t\t<goals>\n\t\t\t\t<goal>propagate-execution-context</goal>\n\t\t\t</goals>\n\t\t</execution>\n\t</executions>\n</plugin>\n";

        @Override
        public EffectivePomMavenDependencyResolver configure(MavenDependencyResolver resolver) {
            String pomFile = SecurityActions.getProperty(POM_FILE_KEY);
            Validate.stateNotNullOrEmpty(pomFile, CONSTRUCTION_EXCEPTION);
            Validate.isReadable(pomFile, "POM file " + pomFile + " does not represent a readable file");
            String userSettings = SecurityActions.getProperty(USER_SETTINGS_KEY);
            Validate.stateNotNullOrEmpty(userSettings, CONSTRUCTION_EXCEPTION);
            boolean hasSettingsXml = true;
            try {
                Validate.isReadable(userSettings, "Settings.xml file " + userSettings + " does not represent a readable file");
            }
            catch (IllegalArgumentException iae) {
                hasSettingsXml = false;
            }
            MavenDependencyResolver updatedResolver = hasSettingsXml ? resolver.loadSettings(userSettings) : resolver;
            boolean offline = "true".equals(SecurityActions.getProperty(OFFLINE_KEY));
            if (offline) {
                updatedResolver = updatedResolver.goOffline();
            }
            return updatedResolver.loadEffectivePom(pomFile);
        }
    };
}

