/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.status;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.jboss.solder.literal.MessageBundleLiteral;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.messages.MessageBundle;
import org.jboss.solder.reflection.annotated.AnnotatedTypeBuilder;

public class TypedStatusMessageBundleExtension
implements Extension {
    private static final Logger log = Logger.getLogger(TypedStatusMessageBundleExtension.class);

    <X> void detectBundleInjectionTargets(@Observes ProcessInjectionTarget<X> event, BeanManager beanManager) {
        AnnotatedType type = event.getAnnotatedType();
        for (AnnotatedField f : type.getFields()) {
            Field field = f.getJavaMember();
            Class<?> clz = field.getType();
            if (!clz.isAnnotationPresent(MessageBundle.class)) continue;
            log.info((Object)("Add @MessageBundle to " + type.getJavaClass().getName() + "." + field.getName() + " injection point for the type: " + clz.getName()));
            AnnotatedTypeBuilder typeBuilder = new AnnotatedTypeBuilder().readFromType(type);
            typeBuilder.addToField(field, (Annotation)MessageBundleLiteral.INSTANCE);
            event.setInjectionTarget(beanManager.createInjectionTarget(typeBuilder.create()));
        }
    }
}

