/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.locale;

import java.io.Serializable;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.international.locale.DefaultLocale;
import org.jboss.seam.international.locale.LocaleUtils;
import org.jboss.solder.logging.Logger;

@ApplicationScoped
public class DefaultLocaleProducer
implements Serializable {
    private static final long serialVersionUID = -4534087316489937649L;
    private Logger log = Logger.getLogger(DefaultLocaleProducer.class);
    @Inject
    @DefaultLocale
    private Instance<String> defaultLocaleKey;
    @Produces
    @Named
    private Locale defaultLocale;

    @PostConstruct
    public void init() {
        if (!this.defaultLocaleKey.isUnsatisfied()) {
            try {
                String key = (String)this.defaultLocaleKey.get();
                this.defaultLocale = LocaleUtils.toLocale(key);
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)("DefaultLocaleProducer: Default Locale key of " + this.defaultLocale + " was not formatted correctly"), (Throwable)e);
            }
        }
        if (null == this.defaultLocale) {
            this.defaultLocale = Locale.getDefault();
        }
    }
}

