/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.locale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.seam.international.locale.LocaleConfiguration;
import org.jboss.seam.international.locale.LocaleUtils;
import org.jboss.solder.logging.Logger;

@ApplicationScoped
public class AvailableLocales {
    private final Logger log = Logger.getLogger(AvailableLocales.class);
    @Produces
    private List<Locale> locales = null;

    @Inject
    public void init(Instance<LocaleConfiguration> configuration) {
        this.locales = new ArrayList<Locale>();
        if (!configuration.isAmbiguous() && !configuration.isUnsatisfied()) {
            Set<String> keys = ((LocaleConfiguration)configuration.get()).getSupportedLocaleKeys();
            this.log.trace((Object)("Found " + keys.size() + " locales in configuration"));
            for (String localeKey : keys) {
                try {
                    Locale lc = LocaleUtils.toLocale(localeKey);
                    this.locales.add(lc);
                }
                catch (IllegalArgumentException e) {
                    this.log.error((Object)("AvailableLocales: Supported Locale key of " + localeKey + " was not formatted correctly"), (Throwable)e);
                }
            }
        }
        Collections.sort(this.locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale a, Locale b) {
                return a.toString().compareTo(b.toString());
            }
        });
        this.locales = Collections.unmodifiableList(this.locales);
    }
}

