/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.util;

public class HexConverter {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static String convertToHexString(byte[] toBeConverted) {
        if (toBeConverted == null) {
            throw new NullPointerException("Parameter to be converted can not be null");
        }
        char[] converted = new char[toBeConverted.length * 2];
        for (int i = 0; i < toBeConverted.length; ++i) {
            byte b = toBeConverted[i];
            converted[i * 2] = HEX_CHARS[b >> 4 & 0xF];
            converted[i * 2 + 1] = HEX_CHARS[b & 0xF];
        }
        return String.valueOf(converted);
    }

    public static byte[] convertToHexBytes(byte[] toBeConverted) {
        if (toBeConverted == null) {
            throw new NullPointerException("Parameter to be converted can not be null");
        }
        byte[] converted = new byte[toBeConverted.length * 2];
        for (int i = 0; i < toBeConverted.length; ++i) {
            byte b = toBeConverted[i];
            converted[i * 2] = HEX_BYTES[b >> 4 & 0xF];
            converted[i * 2 + 1] = HEX_BYTES[b & 0xF];
        }
        return converted;
    }

    public static byte[] convertFromHex(char[] toConvert) {
        if (toConvert.length % 2 != 0) {
            throw new IllegalArgumentException("The supplied character array must contain an even number of hex chars.");
        }
        byte[] response = new byte[toConvert.length / 2];
        for (int i = 0; i < response.length; ++i) {
            int posOne = i * 2;
            response[i] = (byte)(HexConverter.toByte(toConvert, posOne) << 4 | HexConverter.toByte(toConvert, posOne + 1));
        }
        return response;
    }

    private static byte toByte(char[] toConvert, int pos) {
        int response = Character.digit(toConvert[pos], 16);
        if (response < 0 || response > 15) {
            throw new IllegalArgumentException("Non-hex character '" + toConvert[pos] + "' at index=" + pos);
        }
        return (byte)response;
    }

    public static byte[] convertFromHex(String toConvert) {
        return HexConverter.convertFromHex(toConvert.toCharArray());
    }

    public static void main(String[] args) {
        byte[] toConvert = new byte[256];
        for (int i = 0; i < toConvert.length; ++i) {
            toConvert[i] = (byte)i;
        }
        String hexValue = HexConverter.convertToHexString(toConvert);
        System.out.println("Converted - " + hexValue);
        byte[] convertedBack = HexConverter.convertFromHex(hexValue);
        StringBuffer sb = new StringBuffer();
        for (byte current : convertedBack) {
            sb.append(current).append(" ");
        }
        System.out.println("Converted Back " + sb.toString());
    }
}

