/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.wadl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.util.GetRestful;
import org.jboss.resteasy.wadl.ResteasyWadlMethodMetaData;
import org.jboss.resteasy.wadl.ResteasyWadlResourceMetaData;
import org.jboss.resteasy.wadl.i18n.LogMessages;
import org.jboss.resteasy.wadl.i18n.Messages;

public class ResteasyWadlServiceRegistry {
    private ResourceMethodRegistry registry;
    private ResteasyProviderFactory providerFactory;
    private ResteasyWadlServiceRegistry parent;
    private Map<String, ResteasyWadlResourceMetaData> resources;
    private List<ResteasyWadlServiceRegistry> locators;
    private ResourceLocator locator;
    private String uri;
    private String functionPrefix;

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public ResteasyWadlServiceRegistry(ResteasyWadlServiceRegistry parent, ResourceMethodRegistry registry, ResteasyProviderFactory providerFactory, ResourceLocator locator) {
        this.parent = parent;
        this.registry = registry;
        this.providerFactory = providerFactory;
        this.locator = locator;
        if (locator != null) {
            Method method = locator.getMethod();
            Path methodPath = method.getAnnotation(Path.class);
            Class<?> declaringClass = method.getDeclaringClass();
            Path classPath = declaringClass.getAnnotation(Path.class);
            this.uri = ResteasyWadlMethodMetaData.appendURIFragments(parent, classPath, methodPath);
            this.functionPrefix = parent.isRoot() ? declaringClass.getSimpleName() + "." + method.getName() : parent.getFunctionPrefix() + "." + method.getName();
        }
        this.scanRegistry();
    }

    private void scanRegistry() {
        this.resources = new HashMap<String, ResteasyWadlResourceMetaData>();
        this.locators = new ArrayList<ResteasyWadlServiceRegistry>();
        for (Map.Entry entry : this.registry.getBounded().entrySet()) {
            List invokers = (List)entry.getValue();
            for (ResourceInvoker invoker : invokers) {
                Class[] locatorResourceTypes;
                if (invoker instanceof ResourceMethodInvoker) {
                    ResteasyWadlMethodMetaData methodMetaData = new ResteasyWadlMethodMetaData(this, (ResourceMethodInvoker)invoker);
                    ResteasyWadlResourceMetaData resourceMetaData = this.resources.get(methodMetaData.getKlassUri());
                    if (resourceMetaData == null) {
                        resourceMetaData = new ResteasyWadlResourceMetaData(methodMetaData.getKlassUri());
                        this.resources.put(methodMetaData.getKlassUri(), resourceMetaData);
                    }
                    resourceMetaData.addMethodMetaData(methodMetaData);
                    continue;
                }
                if (!(invoker instanceof ResourceLocator)) continue;
                ResourceLocator locator = (ResourceLocator)invoker;
                Method method = locator.getMethod();
                Class<?> locatorType = method.getReturnType();
                for (Class locatorResourceType : locatorResourceTypes = GetRestful.getSubResourceClasses(locatorType)) {
                    if (locatorResourceType == null) {
                        LogMessages.LOGGER.warn(Messages.MESSAGES.impossibleToGenerateWADL(method.getDeclaringClass().getName(), method.getName()));
                        continue;
                    }
                    ResourceMethodRegistry locatorRegistry = new ResourceMethodRegistry(this.providerFactory);
                    locatorRegistry.addResourceFactory(null, null, locatorResourceType);
                    this.locators.add(new ResteasyWadlServiceRegistry(this, locatorRegistry, this.providerFactory, locator));
                }
            }
        }
    }

    public Map<String, ResteasyWadlResourceMetaData> getResources() {
        return this.resources;
    }

    public List<ResteasyWadlServiceRegistry> getLocators() {
        return this.locators;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getFunctionPrefix() {
        return this.functionPrefix;
    }

    public void collectResourceMethodsUntilRoot(List<Method> methods) {
        if (this.isRoot()) {
            return;
        }
        methods.add(this.locator.getMethod());
        this.parent.collectResourceMethodsUntilRoot(methods);
    }
}

