/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.jboss.resteasy.jose.i18n.Messages;

class RSA_OAEP {
    public static byte[] encryptCEK(RSAPublicKey pub, SecretKey cek) throws RuntimeException {
        try {
            RSAEngine engine = new RSAEngine();
            OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)engine);
            BigInteger mod = pub.getModulus();
            BigInteger exp = pub.getPublicExponent();
            RSAKeyParameters keyParams = new RSAKeyParameters(false, mod, exp);
            cipher.init(true, (CipherParameters)keyParams);
            int inputBlockSize = cipher.getInputBlockSize();
            int outputBlockSize = cipher.getOutputBlockSize();
            byte[] keyBytes = cek.getEncoded();
            return cipher.processBlock(keyBytes, 0, keyBytes.length);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.couldntEncryptCEK(e.getLocalizedMessage()), e);
        }
    }

    public static SecretKey decryptCEK(RSAPrivateKey priv, byte[] encryptedCEK) throws RuntimeException {
        try {
            RSAEngine engine = new RSAEngine();
            OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)engine);
            BigInteger mod = priv.getModulus();
            BigInteger exp = priv.getPrivateExponent();
            RSAKeyParameters keyParams = new RSAKeyParameters(true, mod, exp);
            cipher.init(false, (CipherParameters)keyParams);
            byte[] secretKeyBytes = cipher.processBlock(encryptedCEK, 0, encryptedCEK.length);
            return new SecretKeySpec(secretKeyBytes, "AES");
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.couldntDecryptCEK(e.getLocalizedMessage()), e);
        }
    }

    private RSA_OAEP() {
    }
}

