/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import javax.crypto.SecretKey;
import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jose.jwe.Algorithm;
import org.jboss.resteasy.jose.jwe.CompressionAlgorithm;
import org.jboss.resteasy.jose.jwe.EncryptionMethod;
import org.jboss.resteasy.jose.jwe.crypto.AES;
import org.jboss.resteasy.jose.jwe.crypto.AESCBC;
import org.jboss.resteasy.jose.jwe.crypto.AESGCM;
import org.jboss.resteasy.jose.jwe.crypto.AuthenticatedCipherText;
import org.jboss.resteasy.jose.jwe.crypto.DeflateHelper;
import org.jboss.resteasy.jose.jwe.crypto.RSA1_5;
import org.jboss.resteasy.jose.jwe.crypto.RSA_OAEP;

public class RSAEncrypter {
    private static SecureRandom randomGen;

    private static void initSecureRandom() {
        try {
            randomGen = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String encrypt(Algorithm alg, EncryptionMethod enc, CompressionAlgorithm compressionAlgorithm, RSAPublicKey publicKey, String encodedJWEHeader, byte[] bytes) {
        AuthenticatedCipherText authCipherText;
        byte[] iv;
        if (randomGen == null) {
            RSAEncrypter.initSecureRandom();
        }
        SecretKey cek = AES.generateKey(enc.getCekBitLength());
        String encryptedKey = null;
        if (alg.equals((Object)Algorithm.RSA1_5)) {
            encryptedKey = Base64.getUrlEncoder().encodeToString(RSA1_5.encryptCEK(publicKey, cek));
        } else if (alg.equals((Object)Algorithm.RSA_OAEP)) {
            encryptedKey = Base64.getUrlEncoder().encodeToString(RSA_OAEP.encryptCEK(publicKey, cek));
        } else {
            throw new RuntimeException(Messages.MESSAGES.unsupportedJWEalgorithm());
        }
        byte[] plainText = DeflateHelper.applyCompression(compressionAlgorithm, bytes);
        byte[] aad = encodedJWEHeader.getBytes(StandardCharsets.UTF_8);
        if (enc.equals((Object)EncryptionMethod.A128CBC_HS256) || enc.equals((Object)EncryptionMethod.A256CBC_HS512)) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptAuthenticated(cek, iv, plainText, aad);
        } else if (enc.equals((Object)EncryptionMethod.A128GCM) || enc.equals((Object)EncryptionMethod.A256GCM)) {
            iv = AESGCM.generateIV(randomGen);
            authCipherText = AESGCM.encrypt(cek, iv, plainText, aad);
        } else {
            throw new RuntimeException(Messages.MESSAGES.unsupportedEncryptionMethod());
        }
        StringBuilder builder = new StringBuilder(encodedJWEHeader).append('.').append(encryptedKey).append('.').append(Base64.getUrlEncoder().encodeToString(iv)).append('.').append(Base64.getUrlEncoder().encodeToString(authCipherText.getCipherText())).append('.').append(Base64.getUrlEncoder().encodeToString(authCipherText.getAuthenticationTag()));
        return builder.toString();
    }
}

