/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transporter;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.ServerInvokerMetadata;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transporter.DefaultLoadBalancer;
import org.jboss.remoting.transporter.InternalTransporterServices;
import org.jboss.remoting.transporter.LoadBalancer;
import org.jboss.remoting.util.SecurityUtility;

public class TransporterClient
implements InvocationHandler,
Serializable {
    private Client remotingClient = null;
    private boolean isClustered = false;
    private String subSystem = null;
    private LoadBalancer loadBalancer = new DefaultLoadBalancer();
    private final Logger log = Logger.getLogger((Class)TransporterClient.class);
    private static final long serialVersionUID = 7418567482011657189L;
    private Map metadata;

    private TransporterClient(InvokerLocator locator) throws Exception {
        this.remotingClient = new Client(locator);
        this.remotingClient.connect();
    }

    private TransporterClient(InvokerLocator locator, Map metadata) throws Exception {
        this.remotingClient = new Client(locator);
        this.remotingClient.connect();
        this.metadata = metadata;
    }

    private TransporterClient(InvokerLocator locator, String targetSubsystem) throws Exception {
        this.remotingClient = new Client(locator, targetSubsystem);
        this.remotingClient.connect();
        this.isClustered = true;
        this.subSystem = targetSubsystem;
    }

    private TransporterClient(InvokerLocator locator, String targetSubsystem, Map metadata) throws Exception {
        this.remotingClient = new Client(locator, targetSubsystem);
        this.remotingClient.connect();
        this.isClustered = true;
        this.subSystem = targetSubsystem;
        this.metadata = metadata;
    }

    private TransporterClient(InvokerLocator locator, String targetSubsystem, LoadBalancer loadbalancer) throws Exception {
        this.loadBalancer = loadbalancer;
        this.remotingClient = new Client(locator, targetSubsystem);
        this.remotingClient.connect();
        this.isClustered = true;
        this.subSystem = targetSubsystem;
    }

    private TransporterClient(InvokerLocator locator, String targetSubsystem, LoadBalancer loadbalancer, Map metadata) throws Exception {
        this.loadBalancer = loadbalancer;
        this.remotingClient = new Client(locator, targetSubsystem);
        this.remotingClient.connect();
        this.isClustered = true;
        this.subSystem = targetSubsystem;
        this.metadata = metadata;
    }

    private void disconnect() {
        if (this.remotingClient != null) {
            this.remotingClient.disconnect();
        }
    }

    private static void setupDetector() throws Exception {
        InternalTransporterServices services = InternalTransporterServices.getInstance();
        if (!services.isSetup()) {
            MBeanServer server = TransporterClient.createMBeanServer();
            MulticastDetector detector = new MulticastDetector();
            NetworkRegistry registry = NetworkRegistry.getInstance();
            services.setup(server, detector, null, registry, null, true, true);
            detector.start();
        } else {
            if (services.getDetector() == null) {
                MulticastDetector detector = new MulticastDetector();
                services.assignDetector(detector, null, true);
                detector.start();
            }
            if (services.getNetworkRegistry() == null) {
                NetworkRegistry registry = NetworkRegistry.getInstance();
                services.assignNetworkRegistry(registry, null, true);
            }
        }
    }

    public static Object createTransporterClient(String locatorURI, Class targetClass, boolean clustered) throws Exception {
        if (!clustered) {
            return TransporterClient.createTransporterClient(locatorURI, targetClass);
        }
        if (InternalTransporterServices.getInstance().getNetworkRegistry() == null) {
            TransporterClient.setupDetector();
        }
        InvokerLocator locator = new InvokerLocator(locatorURI);
        TransporterClient client = new TransporterClient(locator, targetClass.getName());
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return Proxy.newProxyInstance(tcl, new Class[]{targetClass}, (InvocationHandler)client);
    }

    public static Object createTransporterClient(String locatorURI, Class targetClass, boolean clustered, Map metadata) throws Exception {
        if (!clustered) {
            return TransporterClient.createTransporterClient(locatorURI, targetClass, metadata);
        }
        if (InternalTransporterServices.getInstance().getNetworkRegistry() == null) {
            TransporterClient.setupDetector();
        }
        InvokerLocator locator = new InvokerLocator(locatorURI);
        TransporterClient client = new TransporterClient(locator, targetClass.getName());
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return Proxy.newProxyInstance(tcl, new Class[]{targetClass}, (InvocationHandler)client);
    }

    public static Object createTransporterClient(String locatorURI, Class targetClass, LoadBalancer loadBalancer) throws Exception {
        if (InternalTransporterServices.getInstance().getNetworkRegistry() == null) {
            TransporterClient.setupDetector();
        }
        InvokerLocator locator = new InvokerLocator(locatorURI);
        TransporterClient client = new TransporterClient(locator, targetClass.getName(), loadBalancer);
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return Proxy.newProxyInstance(tcl, new Class[]{targetClass}, (InvocationHandler)client);
    }

    public static Object createTransporterClient(String locatorURI, Class targetClass, LoadBalancer loadBalancer, Map metadata) throws Exception {
        if (InternalTransporterServices.getInstance().getNetworkRegistry() == null) {
            TransporterClient.setupDetector();
        }
        InvokerLocator locator = new InvokerLocator(locatorURI);
        TransporterClient client = new TransporterClient(locator, targetClass.getName(), loadBalancer, metadata);
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return Proxy.newProxyInstance(tcl, new Class[]{targetClass}, (InvocationHandler)client);
    }

    public static Object createTransporterClient(String locatorURI, Class targetClass) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        return TransporterClient.createTransporterClient(locator, targetClass);
    }

    public static Object createTransporterClient(String locatorURI, Class targetClass, Map metadata) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        return TransporterClient.createTransporterClient(locator, targetClass, metadata);
    }

    public static Object createTransporterClient(InvokerLocator locator, Class targetClass) throws Exception {
        TransporterClient client = new TransporterClient(locator, targetClass.getName());
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return Proxy.newProxyInstance(tcl, new Class[]{targetClass}, (InvocationHandler)client);
    }

    public static Object createTransporterClient(InvokerLocator locator, Class targetClass, Map metadata) throws Exception {
        TransporterClient client = new TransporterClient(locator, targetClass.getName(), metadata);
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return Proxy.newProxyInstance(tcl, new Class[]{targetClass}, (InvocationHandler)client);
    }

    public static void destroyTransporterClient(Object transporterClient) {
        InvocationHandler handler;
        if (transporterClient instanceof Proxy) {
            handler = Proxy.getInvocationHandler(transporterClient);
            if (!(handler instanceof TransporterClient)) {
                throw new IllegalArgumentException("Object is not a transporter client.");
            }
        } else {
            throw new IllegalArgumentException("Object is not a transporter client.");
        }
        TransporterClient client = (TransporterClient)handler;
        client.disconnect();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        String[] paramSig = this.createParamSignature(method.getParameterTypes());
        NameBasedInvocation request = new NameBasedInvocation(methodName, args, paramSig);
        Object response = null;
        boolean failOver = false;
        do {
            try {
                failOver = false;
                if (this.metadata != null) {
                    response = this.remotingClient.invoke(request, this.metadata);
                    continue;
                }
                response = this.remotingClient.invoke(request);
            }
            catch (CannotConnectException cnc) {
                failOver = this.findAlternativeTarget();
                if (failOver) continue;
                throw cnc;
            }
            catch (InvocationTargetException itex) {
                Throwable rootEx = itex.getCause();
                throw rootEx;
            }
        } while (failOver);
        return response;
    }

    private boolean findAlternativeTarget() {
        NetworkInstance[] instances;
        boolean failover = false;
        ArrayList<ServerInvokerMetadata> availableList = new ArrayList<ServerInvokerMetadata>();
        NetworkRegistry registry = InternalTransporterServices.getInstance().getNetworkRegistry();
        if (registry != null && (instances = registry.getServers()) != null) {
            for (int x = 0; x < instances.length; ++x) {
                NetworkInstance netInstance = instances[x];
                ServerInvokerMetadata[] metadata = netInstance.getServerInvokers();
                for (int i = 0; i < metadata.length; ++i) {
                    ServerInvokerMetadata data = metadata[i];
                    String[] subsystems = data.getSubSystems();
                    for (int z = 0; z < subsystems.length; ++z) {
                        if (!this.subSystem.equalsIgnoreCase(subsystems[z])) continue;
                        availableList.add(data);
                    }
                }
            }
            if (availableList.size() > 0) {
                int index = this.loadBalancer.selectServer(availableList);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Total of " + availableList.size() + " available servers found."));
                    this.log.debug((Object)("Using server number " + index));
                }
                ServerInvokerMetadata data = (ServerInvokerMetadata)availableList.get(index);
                InvokerLocator newLocator = data.getInvokerLocator();
                if (!this.remotingClient.getInvoker().getLocator().equals(newLocator)) {
                    try {
                        this.remotingClient = new Client(newLocator);
                        this.remotingClient.connect();
                        return true;
                    }
                    catch (Exception e) {
                        this.log.warn((Object)"Problem connecting to newly found alternate target.", (Throwable)e);
                    }
                }
            }
        }
        return failover;
    }

    private String[] createParamSignature(Class[] args) {
        if (args == null || args.length == 0) {
            return new String[0];
        }
        String[] paramSig = new String[args.length];
        for (int x = 0; x < args.length; ++x) {
            paramSig[x] = args[x].getName();
        }
        return paramSig;
    }

    private static MBeanServer createMBeanServer() throws Exception {
        if (SecurityUtility.skipAccessControl()) {
            return MBeanServerFactory.createMBeanServer();
        }
        try {
            return (MBeanServer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return MBeanServerFactory.createMBeanServer();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }
}

