/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.Invoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.Version;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.socketfactory.CreationListenerSocketFactory;
import org.jboss.remoting.socketfactory.SocketCreationListener;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
import org.jboss.util.id.GUID;

public abstract class AbstractInvoker
implements Invoker {
    protected static final Logger log = Logger.getLogger((Class)AbstractInvoker.class);
    protected ClassByteClassLoader classbyteloader;
    protected InvokerLocator locator;
    protected Map localServerLocators;
    protected String serializationType;
    protected Map configuration;
    protected SocketFactory socketFactory;
    protected int version;
    protected boolean passConfigMapToMarshalFactory;
    protected boolean socketFactoryCreatedFromSSLParameters;

    public AbstractInvoker(InvokerLocator locator) {
        this(locator, null);
    }

    public AbstractInvoker(InvokerLocator locator, Map configuration) {
        Object o;
        block22: {
            this.localServerLocators = new HashMap();
            this.configuration = new HashMap();
            try {
                this.classbyteloader = (ClassByteClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new ClassByteClassLoader((class$org$jboss$remoting$AbstractInvoker == null ? (class$org$jboss$remoting$AbstractInvoker = AbstractInvoker.class$("org.jboss.remoting.AbstractInvoker")) : class$org$jboss$remoting$AbstractInvoker).getClassLoader());
                    }
                });
            }
            catch (PrivilegedActionException e) {
                log.debug((Object)e.toString(), (Throwable)e);
                throw new RuntimeException("Can't create a ClassLoader", e);
            }
            this.locator = locator;
            if (this.checkConfigOverridesLocator(locator, configuration)) {
                if (locator.getParameters() != null) {
                    this.configuration.putAll(locator.getParameters());
                }
                if (configuration != null) {
                    this.configuration.putAll(configuration);
                }
            } else {
                if (configuration != null) {
                    this.configuration.putAll(configuration);
                }
                if (locator.getParameters() != null) {
                    this.configuration.putAll(locator.getParameters());
                }
            }
            try {
                InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
                if (loaderLocator != null) {
                    this.classbyteloader.setClientInvoker(new Client(loaderLocator));
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not create remote class loading for invoker.", (Throwable)e);
            }
            if (locator == null || locator.getParameters() == null) {
                this.setSerializationType("java");
            } else {
                this.setSerializationType(locator.findSerializationType());
            }
            this.setVersion(Version.getDefaultVersion());
            o = this.configuration.get("remotingVersion");
            if (o instanceof String) {
                try {
                    int v = Integer.valueOf((String)o);
                    if (Version.isValidVersion(v)) {
                        log.debug((Object)(this + " setting version to " + v));
                        this.setVersion(v);
                        break block22;
                    }
                    log.debug((Object)(this + " invalid version: " + v + ". Using " + this.getVersion()));
                }
                catch (Exception e) {
                    log.warn((Object)(this + " could not convert " + "remotingVersion" + " value of " + o + " to an int value. Using " + this.getVersion()));
                }
            } else if (o != null) {
                log.warn((Object)(this + " value of " + "remotingVersion" + " must be a String: " + o + ". Using " + this.getVersion()));
            }
        }
        if ((o = this.configuration.get("passConfigMapToMarshalFactory")) instanceof String) {
            this.passConfigMapToMarshalFactory = Boolean.valueOf((String)o);
        } else if (o != null) {
            log.warn((Object)("value of passConfigMapToMarshalFactory must be a String: " + o));
        }
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addClientLocator(String sessionId, InvokerCallbackHandler callbackhandler, InvokerLocator locator) {
        String listenerId = null;
        Map map = this.localServerLocators;
        synchronized (map) {
            CallbackHandlerHolder holder;
            Collection holders = this.localServerLocators.values();
            Iterator itr = holders.iterator();
            while (itr.hasNext()) {
                holder = (CallbackHandlerHolder)itr.next();
                InvokerCallbackHandler holderhandler = holder.getHandler();
                boolean handlersEqual = holderhandler.equals(callbackhandler);
                InvokerLocator handlerLocator = holder.getLocator();
                boolean locatorsEqual = handlerLocator.equals(locator);
                if (!handlersEqual || !locatorsEqual) continue;
                return null;
            }
            holder = new CallbackHandlerHolder(callbackhandler, locator);
            String key = listenerId = new GUID().toString();
            if (sessionId != null) {
                key = sessionId + "+" + listenerId;
            }
            this.localServerLocators.put(key, holder);
        }
        return listenerId;
    }

    public InvokerLocator getClientLocator(String listenerId) {
        CallbackHandlerHolder holder;
        InvokerLocator locator = null;
        if (listenerId != null && (holder = (CallbackHandlerHolder)this.localServerLocators.get(listenerId)) != null) {
            locator = holder.getLocator();
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getClientLocators(String sessionId, InvokerCallbackHandler handler) {
        ArrayList<CallbackLocatorHolder> holderList = new ArrayList<CallbackLocatorHolder>();
        if (handler != null) {
            Map map = this.localServerLocators;
            synchronized (map) {
                String listenerId;
                Set entries = this.localServerLocators.entrySet();
                Iterator itr = entries.iterator();
                while (itr.hasNext()) {
                    CallbackHandlerHolder holder;
                    InvokerCallbackHandler holderHandler;
                    int index;
                    Map.Entry entry = itr.next();
                    listenerId = (String)entry.getKey();
                    String prefix = listenerId.substring(0, index = listenerId.indexOf(43));
                    if (!sessionId.equals(prefix)) continue;
                    if (index >= 0) {
                        listenerId = listenerId.substring(index + 1);
                    }
                    if (!(holderHandler = (holder = (CallbackHandlerHolder)entry.getValue()).getHandler()).equals(handler)) continue;
                    CallbackLocatorHolder locatorHolder = new CallbackLocatorHolder(listenerId, holder.getLocator());
                    holderList.add(locatorHolder);
                }
                if (holderList.size() > 0) {
                    for (int x = 0; x < holderList.size(); ++x) {
                        listenerId = ((CallbackLocatorHolder)holderList.get(x)).getListenerId();
                        String key = sessionId + "+" + listenerId;
                        this.localServerLocators.remove(key);
                    }
                }
            }
        }
        return holderList;
    }

    public synchronized void setClassLoader(final ClassLoader classloader) {
        try {
            this.classbyteloader = (ClassByteClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new ClassByteClassLoader(classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw new RuntimeException("Can't create a ClassLoader", e);
        }
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classbyteloader;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public boolean isSocketFactoryCreatedFromSSLParameters() {
        return this.socketFactoryCreatedFromSSLParameters;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        if (configuration == null) {
            return null;
        }
        if (this.socketFactory != null) {
            return this.socketFactory;
        }
        SocketFactory factory = null;
        Object obj = configuration.get("customSocketFactory");
        if (obj != null) {
            if (obj instanceof SocketFactory) {
                factory = (SocketFactory)obj;
            } else {
                throw new RuntimeException("Can not set custom socket factory (" + obj + ") as is not of type javax.net.SocketFactory");
            }
        }
        if (factory == null) {
            String socketFactoryString = (String)configuration.get("socketFactory");
            if (socketFactoryString == null) {
                socketFactoryString = (String)configuration.get("socketFactoryClassName");
            }
            if (socketFactoryString != null && socketFactoryString.length() > 0) {
                try {
                    Class cl = ClassLoaderUtility.loadClass(socketFactoryString, this.getClass());
                    Constructor socketFactoryConstructor = null;
                    socketFactoryConstructor = cl.getConstructor(new Class[0]);
                    factory = (SocketFactory)socketFactoryConstructor.newInstance(new Object[0]);
                    log.trace((Object)("SocketFactory (" + socketFactoryString + ") loaded"));
                }
                catch (Exception e) {
                    log.debug((Object)("Could not create socket factory by classname (" + socketFactoryString + ").  Error message: " + e.getMessage()));
                }
            }
        }
        if (factory == null && AbstractInvoker.needsCustomSSLConfiguration(configuration)) {
            try {
                SSLSocketBuilder socketBuilder = new SSLSocketBuilder(configuration);
                socketBuilder.setUseSSLSocketFactory(false);
                factory = socketBuilder.createSSLSocketFactory();
                this.socketFactoryCreatedFromSSLParameters = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create customized SSL socket factory", e);
            }
        }
        return AbstractInvoker.wrapSocketFactory(factory, configuration);
    }

    protected Map getConfiguration() {
        return this.configuration;
    }

    protected boolean checkConfigOverridesLocator(InvokerLocator locator, Map config) {
        Object o;
        Map map;
        Object o2;
        boolean result = false;
        if (config != null && (o2 = config.get("configOverridesLocator")) != null) {
            if (o2 instanceof String) {
                result = Boolean.valueOf((String)o2);
            } else {
                log.warn((Object)("value of configOverridesLocator in configuration Map should be a String instead of: " + o2));
            }
        }
        if ((map = locator.parameters) != null && (o = map.get("configOverridesLocator")) != null) {
            if (o instanceof String) {
                result = Boolean.valueOf((String)o);
            } else {
                log.warn((Object)("value of configOverridesLocator in " + locator + " should be a String"));
            }
        }
        return result;
    }

    public static SocketFactory wrapSocketFactory(SocketFactory socketFactory, Map config) {
        if (config == null) {
            return socketFactory;
        }
        Object o = config.get("socketCreationClientListener");
        if (o == null) {
            return socketFactory;
        }
        if (o instanceof SocketCreationListener) {
            SocketCreationListener listener = (SocketCreationListener)o;
            return new CreationListenerSocketFactory(socketFactory, listener);
        }
        if (o instanceof String) {
            try {
                Class c = ClassLoaderUtility.loadClass((String)o, AbstractInvoker.class);
                SocketCreationListener listener = (SocketCreationListener)c.newInstance();
                return new CreationListenerSocketFactory(socketFactory, listener);
            }
            catch (Exception e) {
                log.warn((Object)("unable to instantiate class: " + o), (Throwable)e);
                return socketFactory;
            }
        }
        log.warn((Object)("unrecognized type for socket creation client listener: " + o));
        return socketFactory;
    }

    public static boolean isCompleteSocketFactory(SocketFactory sf) {
        return sf != null && (!(sf instanceof SocketFactoryWrapper) || ((SocketFactoryWrapper)((Object)sf)).getSocketFactory() != null);
    }

    public static boolean needsCustomSSLConfiguration(Map configuration) {
        return configuration.get("org.jboss.remoting.keyAlias") != null || configuration.get("org.jboss.remoting.clientAuthMode") != null || configuration.get("org.jboss.remoting.serverAuthMode") != null || configuration.get("org.jboss.remoting.sslProtocol") != null || configuration.get("org.jboss.remoting.sslProviderName") != null || configuration.get("org.jboss.remoting.serversocket.useClientMode") != null || configuration.get("org.jboss.remoting.socket.useClientMode") != null || configuration.get("org.jboss.remoting.keyPassword") != null || configuration.get("org.jboss.remoting.keyStoreAlgorithm") != null || configuration.get("org.jboss.remoting.keyStore") != null || configuration.get("org.jboss.remoting.keyStorePassword") != null || configuration.get("org.jboss.remoting.keyStoreType") != null || configuration.get("org.jboss.remoting.trustStoreAlgorithm") != null || configuration.get("org.jboss.remoting.trustStore") != null || configuration.get("org.jboss.remoting.trustStorePassword") != null || configuration.get("org.jboss.remoting.trustStoreType") != null;
    }

    public class CallbackLocatorHolder {
        private InvokerLocator locator;
        private String listenerId;

        public CallbackLocatorHolder(String listenerId, InvokerLocator locator) {
            this.listenerId = listenerId;
            this.locator = locator;
        }

        public String getListenerId() {
            return this.listenerId;
        }

        public InvokerLocator getLocator() {
            return this.locator;
        }
    }

    private class CallbackHandlerHolder {
        private InvokerCallbackHandler handler;
        private InvokerLocator locator;

        private CallbackHandlerHolder(InvokerCallbackHandler handler, InvokerLocator locator) {
            this.handler = handler;
            this.locator = locator;
        }

        public InvokerCallbackHandler getHandler() {
            return this.handler;
        }

        public InvokerLocator getLocator() {
            return this.locator;
        }
    }
}

