/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.StateStatus;
import com.arjuna.ats.arjuna.objectstore.StateType;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.SyncFailedException;

public class ShadowingStore
extends FileSystemStore {
    public static final char HIDDINGCHAR = '#';
    public static final char SHADOWCHAR = '!';

    @Override
    public int currentState(Uid objUid, String tName) throws ObjectStoreException {
        int theState = -1;
        String path = this.genPathName(objUid, tName, 10);
        if (this.exists(path)) {
            theState = 2;
        } else if (this.exists(path = path + '#')) {
            theState = 6;
        } else {
            path = this.genPathName(objUid, tName, 11);
            if (this.exists(path)) {
                theState = 1;
            } else if (this.exists(path = path + '#')) {
                theState = 5;
            }
        }
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.currentState(" + objUid + ", " + tName + ") - returning " + StateStatus.stateStatusString(theState)));
        }
        return theState;
    }

    @Override
    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.commit_state(" + objUid + ", " + tName + ")"));
        }
        boolean result = false;
        if (tName != null) {
            String shadow = null;
            String filename = null;
            int state = this.currentState(objUid, tName);
            if (state == 6 || state == 2) {
                File originalState;
                File shadowState;
                shadow = this.genPathName(objUid, tName, 10);
                filename = this.genPathName(objUid, tName, 11);
                if (state == 6) {
                    shadow = shadow + '#';
                    filename = filename + '#';
                }
                if (!(result = this.renameFromTo(shadowState = new File(shadow), originalState = new File(filename)))) {
                    tsLogger.i18NLogger.warn_objectstore_ShadowingStore_2(shadow, filename);
                } else {
                    super.addToCache(filename);
                    super.removeFromCache(shadow);
                }
                shadowState = null;
                originalState = null;
            } else {
                result = true;
            }
        } else {
            throw new ObjectStoreException("ShadowStore::commit_state - " + tsLogger.i18NLogger.get_objectstore_notypenameuid() + objUid);
        }
        return result;
    }

    @Override
    public boolean hide_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.hide_state(" + objUid + ", " + tName + ")"));
        }
        boolean hiddenOk = true;
        int state = this.currentState(objUid, tName);
        String path1 = null;
        String path2 = null;
        switch (state) {
            case 5: 
            case 6: {
                break;
            }
            case 1: {
                path1 = this.genPathName(objUid, tName, 11);
                path2 = new String(path1) + '#';
                File newState = new File(path1);
                File oldState = new File(path2);
                if (this.renameFromTo(newState, oldState)) {
                    super.removeFromCache(path1);
                    super.addToCache(path2);
                } else {
                    tsLogger.i18NLogger.warn_objectstore_ShadowingStore_3(newState.getName(), oldState.getName());
                }
                newState = null;
                oldState = null;
                break;
            }
            case 2: {
                path1 = this.genPathName(objUid, tName, 10);
                path2 = new String(path1) + '#';
                File newState = new File(path1);
                File oldState = new File(path2);
                if (this.renameFromTo(newState, oldState)) {
                    super.removeFromCache(path1);
                    super.addToCache(path2);
                } else {
                    tsLogger.i18NLogger.warn_objectstore_ShadowingStore_3(newState.getName(), oldState.getName());
                }
                newState = null;
                oldState = null;
                break;
            }
            default: {
                hiddenOk = false;
            }
        }
        return hiddenOk;
    }

    @Override
    public boolean reveal_state(Uid objUid, String tName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.reveal_state(" + objUid + ", " + tName + ")"));
        }
        boolean revealedOk = true;
        int state = this.currentState(objUid, tName);
        String path1 = null;
        String path2 = null;
        switch (state) {
            case 6: {
                path1 = this.genPathName(objUid, tName, 10);
                path2 = new String(path1) + '#';
                File newState = new File(path2);
                File oldState = new File(path1);
                if (this.renameFromTo(newState, oldState)) {
                    super.removeFromCache(path2);
                    super.addToCache(path1);
                } else {
                    tsLogger.i18NLogger.warn_objectstore_ShadowingStore_4(newState.getName(), oldState.getName());
                }
                newState = null;
                oldState = null;
                break;
            }
            case 5: {
                path1 = this.genPathName(objUid, tName, 11);
                path2 = new String(path1) + '#';
                File newState = new File(path2);
                File oldState = new File(path1);
                if (this.renameFromTo(newState, oldState)) {
                    super.removeFromCache(path2);
                    super.addToCache(path1);
                } else {
                    tsLogger.i18NLogger.warn_objectstore_ShadowingStore_4(newState.getName(), oldState.getName());
                }
                newState = null;
                oldState = null;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                revealedOk = false;
            }
        }
        return revealedOk;
    }

    @Override
    protected String genPathName(Uid objUid, String tName, int ft) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.genPathName(" + objUid + ", " + tName + ", " + StateType.stateTypeString(ft) + ")"));
        }
        String fname = super.genPathName(objUid, tName, ft);
        if (ft == 10) {
            fname = fname + '!';
        }
        return fname;
    }

    @Override
    protected String revealedId(String name) {
        int index = name.indexOf(35);
        if (index == -1) {
            index = name.indexOf(33);
        }
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    @Override
    protected InputObjectState read_state(Uid objUid, String tName, int ft) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.read_state(" + objUid + ", " + tName + ", " + StateType.stateTypeString(ft) + ")"));
        }
        InputObjectState new_image = null;
        if (tName != null) {
            int state = this.currentState(objUid, tName);
            if (state == 1 || state == 2) {
                if (state == 1 && ft != 11 || state == 2 && ft != 10) {
                    tsLogger.logger.info((Object)("Object state " + objUid + " for type " + tName + " has changed on disk from what was expected."));
                    return null;
                }
                String fname = this.genPathName(objUid, tName, ft);
                File fd = this.openAndLock(fname, 0, false);
                if (fd != null) {
                    int imageSize = (int)fd.length();
                    byte[] buffer = new byte[imageSize];
                    FileInputStream ifile = null;
                    try {
                        ifile = new FileInputStream(fd);
                    }
                    catch (FileNotFoundException e) {
                        this.closeAndUnlock(fd, ifile, null);
                        tsLogger.logger.info((Object)("ObjectStore record was deleted during restoration, users should not deleted records manually: " + fd.getAbsolutePath()), (Throwable)e);
                        return null;
                    }
                    try {
                        if (buffer != null && ifile.read(buffer, 0, imageSize) == imageSize) {
                            new_image = new InputObjectState(objUid, tName, buffer);
                        } else {
                            tsLogger.i18NLogger.warn_objectstore_ShadowingStore_7();
                        }
                    }
                    catch (IOException e) {
                        this.closeAndUnlock(fd, ifile, null);
                        throw new ObjectStoreException("ShadowingStore::read_state failed: " + e, e);
                    }
                    if (!this.closeAndUnlock(fd, ifile, null)) {
                        tsLogger.i18NLogger.warn_objectstore_ShadowingStore_8(fname);
                    }
                } else {
                    tsLogger.i18NLogger.warn_objectstore_ShadowingStore_5(fname);
                }
            } else if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("ShadowingStore.read_state could not find committed or uncommitted state for " + objUid + " instead found state " + StateStatus.stateStatusString(state)));
            }
        } else {
            throw new ObjectStoreException("ShadowStore::read_state - " + tsLogger.i18NLogger.get_objectstore_notypenameuid() + objUid);
        }
        return new_image;
    }

    @Override
    protected boolean remove_state(Uid objUid, String name, int ft) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.remove_state(" + objUid + ", " + name + ", " + StateType.stateTypeString(ft) + ")"));
        }
        boolean removeOk = true;
        if (name != null) {
            int state = this.currentState(objUid, name);
            if (state == 1 || state == 2) {
                String fname = this.genPathName(objUid, name, ft);
                File fd = this.openAndLock(fname, 1, false);
                if (fd != null) {
                    if (!fd.canWrite()) {
                        removeOk = false;
                        if (ft == 11) {
                            tsLogger.i18NLogger.warn_objectstore_ShadowingStore_9(objUid, name);
                            if (!fd.exists()) {
                                tsLogger.i18NLogger.warn_objectstore_ShadowingStore_10(objUid, name);
                            }
                        }
                    } else if (!fd.delete()) {
                        removeOk = false;
                        if (ft == 11) {
                            tsLogger.i18NLogger.warn_objectstore_ShadowingStore_11(fname);
                        }
                    }
                    this.closeAndUnlock(fd, null, null);
                } else {
                    tsLogger.i18NLogger.warn_objectstore_ShadowingStore_12(objUid);
                    removeOk = false;
                }
                if (removeOk) {
                    super.removeFromCache(fname);
                }
            } else {
                removeOk = false;
                if (state == -1) {
                    tsLogger.i18NLogger.info_objectstore_ShadowingStore_14(objUid, name);
                } else {
                    tsLogger.i18NLogger.info_objectstore_ShadowingStore_15(objUid, name);
                }
            }
        } else {
            removeOk = false;
            tsLogger.i18NLogger.warn_objectstore_ShadowingStore_17(objUid);
        }
        return removeOk;
    }

    @Override
    protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int ft) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("ShadowingStore.write_state(" + objUid + ", " + tName + ", " + StateType.stateTypeString(ft) + ")"));
        }
        if (tName != null) {
            String fname = this.genPathName(objUid, tName, ft);
            File fd = this.openAndLock(fname, 1, true);
            int imageSize = state.length();
            if (fd == null) {
                tsLogger.i18NLogger.warn_objectstore_ShadowingStore_18(fname);
                return false;
            }
            FileOutputStream ofile = null;
            if (imageSize > 0) {
                try {
                    ofile = new FileOutputStream(fd);
                    ofile.write(state.buffer(), 0, imageSize);
                    if (this.synchronousWrites()) {
                        ofile.flush();
                        FileDescriptor fileDesc = ofile.getFD();
                        fileDesc.sync();
                    }
                }
                catch (SyncFailedException e) {
                    this.closeAndUnlock(fd, null, ofile);
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed to sync for " + fname, e);
                }
                catch (FileNotFoundException e) {
                    this.closeAndUnlock(fd, null, ofile);
                    e.printStackTrace();
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed to locate file " + fname + ": " + e, e);
                }
                catch (IOException e) {
                    this.closeAndUnlock(fd, null, ofile);
                    e.printStackTrace();
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed for " + fname + ": " + e, e);
                }
            }
            if (!this.closeAndUnlock(fd, null, ofile)) {
                tsLogger.i18NLogger.warn_objectstore_ShadowingStore_19(fname);
            }
            super.addToCache(fname);
            return true;
        }
        throw new ObjectStoreException("ShadowStore::write_state - " + tsLogger.i18NLogger.get_objectstore_notypenameuid() + objUid);
    }

    public ShadowingStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
    }
}

