/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SimpleDependentValueCompleter
extends DefaultCompleter {
    private static final List<String> BOOLEAN = Arrays.asList("false", "true");

    public SimpleDependentValueCompleter(final OperationRequestAddress address, final String idProperty) {
        super(new DefaultCompleter.CandidatesProvider(){
            ModelNode allAttrs;

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelNode allowedNode;
                String propName = ctx.getParsedCommandLine().getPropertyValue(idProperty);
                if (propName == null) {
                    return Collections.emptyList();
                }
                if (this.allAttrs == null) {
                    ModelNode response;
                    ModelNode req = new ModelNode();
                    ModelNode addrNode = req.get("address");
                    for (OperationRequestAddress.Node node : address) {
                        addrNode.add(node.getType(), node.getName());
                    }
                    req.get("operation").set("read-resource-description");
                    try {
                        response = ctx.getModelControllerClient().execute(req);
                    }
                    catch (Exception e) {
                        return Collections.emptyList();
                    }
                    ModelNode result = response.get("result");
                    if (!result.isDefined()) {
                        return Collections.emptyList();
                    }
                    this.allAttrs = result.get("attributes");
                }
                if (!this.allAttrs.isDefined()) {
                    return Collections.emptyList();
                }
                ModelNode propDescr = this.allAttrs.get(propName);
                if (!propDescr.isDefined()) {
                    return Collections.emptyList();
                }
                ModelNode typeNode = propDescr.get("type");
                if (typeNode.isDefined() && typeNode.asType().equals((Object)ModelType.BOOLEAN)) {
                    return BOOLEAN;
                }
                if (propDescr.has("allowed") && (allowedNode = propDescr.get("allowed")).isDefined()) {
                    List nodeList = allowedNode.asList();
                    ArrayList<String> values = new ArrayList<String>(nodeList.size());
                    for (ModelNode node : nodeList) {
                        values.add(node.asString());
                    }
                    return values;
                }
                return Collections.emptyList();
            }
        });
    }
}

