/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.jacoco.client;

import java.util.Map;
import org.jboss.arquillian.extension.jacoco.client.ManifestAsset;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureRemover {
    public void removeSignatures(Archive<?> archive) {
        this.removeSignatureFiles(archive);
        this.removeManifestDigests(archive);
    }

    public void removeSignatureFiles(Archive<?> archive) {
        Map<ArchivePath, Node> signatureFiles = this.getSignatureFiles(archive);
        for (Map.Entry<ArchivePath, Node> entry : signatureFiles.entrySet()) {
            archive.delete(entry.getKey());
        }
    }

    public void removeManifestDigests(Archive<?> archive) {
        Map<ArchivePath, Node> manifests = this.getManifestFiles(archive);
        for (Map.Entry<ArchivePath, Node> entry : manifests.entrySet()) {
            Asset original = entry.getValue().getAsset();
            archive.delete(entry.getKey());
            archive.add((Asset)new ManifestAsset(original), entry.getKey());
        }
    }

    public Map<ArchivePath, Node> getSignatureFiles(Archive<?> archive) {
        return archive.getContent(Filters.include((String)"/META-INF/[^/]*\\.SF|/META-INF/[^/]*\\.DSA|/META-INF/[^/]*\\.RSA|/META-INF/SIG-[^/]*"));
    }

    public Map<ArchivePath, Node> getManifestFiles(Archive<?> archive) {
        return archive.getContent(Filters.include((String)"/META-INF/MANIFEST\\.MF"));
    }
}

