/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1.mock;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Instance;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.BeanDeploymentArchiveImpl;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.BeansXmlUtil;
import org.jboss.arquillian.container.weld.ee.embedded_1_1.mock.DeploymentFactory;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.manager.api.WeldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContainer {
    private final Deployment deployment;
    private final Bootstrap bootstrap = new WeldBootstrap();
    private Map<String, Object> sessionStore;

    public TestContainer(BeansXml beansXml, Collection<Class<?>> classes) {
        this(DeploymentFactory.forBeanDeploymentArchive(new BeanDeploymentArchiveImpl(beansXml, classes)));
    }

    public TestContainer(Collection<URL> beansXml, Collection<Class<?>> classes) {
        this.deployment = DeploymentFactory.forBeanDeploymentArchive(new BeanDeploymentArchiveImpl(this.bootstrap.parse(beansXml), classes));
    }

    public TestContainer(String beanArchiveId, Collection<URL> beansXml, Collection<Class<?>> classes) {
        this(beanArchiveId, beansXml, classes, false);
    }

    public TestContainer(String beanArchiveId, Collection<URL> beansXml, Collection<Class<?>> classes, boolean merge) {
        BeansXml xml;
        try {
            xml = BeansXmlUtil.prepareBeansXml(this.bootstrap, beansXml, merge);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse beans.xml", e);
        }
        this.deployment = DeploymentFactory.forBeanDeploymentArchive(new BeanDeploymentArchiveImpl(beanArchiveId, xml, classes));
    }

    public TestContainer(BeansXml beansXml, Class<?> ... classes) {
        this(DeploymentFactory.forBeanDeploymentArchive(new BeanDeploymentArchiveImpl(beansXml, Arrays.asList(classes))));
    }

    public TestContainer(Class<?> ... classes) {
        this(DeploymentFactory.forBeanDeploymentArchive(new BeanDeploymentArchiveImpl(Arrays.asList(classes))));
    }

    public TestContainer(Deployment deployment) {
        this.deployment = deployment;
    }

    public TestContainer ensureRequestActive() {
        RequestContext requestContext = (RequestContext)this.instance().select(RequestContext.class, new Annotation[]{UnboundLiteral.INSTANCE}).get();
        requestContext.activate();
        BoundSessionContext sessionContext = (BoundSessionContext)this.instance().select(BoundSessionContext.class, new Annotation[0]).get();
        sessionContext.associate(this.sessionStore);
        sessionContext.activate();
        return this;
    }

    public TestContainer startContainer() {
        this.sessionStore = new HashMap<String, Object>();
        this.bootstrap.startContainer((Environment)Environments.EE_INJECT, this.deployment).startInitialization().deployBeans().validateBeans().endInitialization();
        return this;
    }

    public WeldManager getBeanManager(BeanDeploymentArchive beanDeploymentArchive) {
        return this.bootstrap.getManager(beanDeploymentArchive);
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public TestContainer stopContainer() {
        BoundSessionContext sessionContext;
        RequestContext requestContext = (RequestContext)this.instance().select(RequestContext.class, new Annotation[]{UnboundLiteral.INSTANCE}).get();
        if (requestContext.isActive()) {
            requestContext.invalidate();
            requestContext.deactivate();
        }
        if ((sessionContext = (BoundSessionContext)this.instance().select(BoundSessionContext.class, new Annotation[0]).get()).isActive()) {
            sessionContext.invalidate();
            sessionContext.deactivate();
            sessionContext.dissociate(this.sessionStore);
        }
        this.bootstrap.shutdown();
        return this;
    }

    public Instance<Context> instance() {
        return Container.instance().deploymentManager().instance().select(Context.class, new Annotation[0]);
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public Map<String, Object> getSessionStore() {
        return this.sessionStore;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Runner {
        private static Runnable NO_OP = new Runnable(){

            public void run(WeldManager beanManager) {
            }
        };
        private final List<URL> beansXml;
        private final List<Class<?>> classes;

        public Runner(List<URL> beansXml, List<Class<?>> classes) {
            this.beansXml = beansXml;
            this.classes = classes;
        }

        public void run() throws Exception {
            this.run(NO_OP);
        }

        public void run(Runnable runnable) throws Exception {
            TestContainer container = null;
            try {
                container = new TestContainer(this.beansXml, this.classes);
                container.startContainer().ensureRequestActive();
                runnable.run(container.getBeanManager((BeanDeploymentArchive)container.getDeployment().getBeanDeploymentArchives().iterator().next()));
            }
            finally {
                if (container != null) {
                    container.stopContainer();
                }
            }
        }

        public void runAndExpect(Exception expected) {
            this.runAndExpect(NO_OP, expected);
        }

        public void runAndExpect(Runnable runnable, Exception expected) {
            block4: {
                try {
                    this.run();
                }
                catch (Exception e) {
                    if (!expected.getClass().isAssignableFrom(e.getClass())) {
                        AssertionError t = new AssertionError((Object)("Expected exception " + expected + " but got " + e));
                        ((Throwable)((Object)t)).initCause(e);
                        throw t;
                    }
                    if (expected.getMessage() == null) {
                        return;
                    }
                    String errorCode = expected.getMessage().substring(0, 11);
                    if (!e.getMessage().startsWith(errorCode)) break block4;
                    return;
                }
            }
            throw new AssertionError((Object)("Expected exception " + expected + " but none was thrown"));
        }

        public static interface Runnable {
            public void run(WeldManager var1);
        }
    }
}

