/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jetty.embedded_9;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.arquillian.container.jetty.embedded_9.JettyEmbeddedConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ArquillianAppProvider
extends AbstractLifeCycle
implements AppProvider {
    private static final Logger LOG;
    private static final String EXPORT_FILE_PREFIX = "export";
    private static final File EXPORT_DIR;
    private final JettyEmbeddedConfiguration config;
    private DeploymentManager deploymentManager;

    public ArquillianAppProvider(JettyEmbeddedConfiguration config) {
        this.config = config;
    }

    protected App createApp(Archive<?> archive) {
        File exported;
        String name = archive.getName();
        int extOff = name.lastIndexOf(46);
        if (extOff <= 0) {
            throw new RuntimeException("Not a valid Web Archive filename: " + name);
        }
        String ext = name.substring(extOff).toLowerCase();
        if (!ext.equals(".war")) {
            throw new RuntimeException("Not a recognized Web Archive: " + name);
        }
        name = name.substring(0, extOff);
        try {
            exported = File.createTempFile(EXPORT_FILE_PREFIX, archive.getName(), EXPORT_DIR);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary File in " + EXPORT_DIR + " to write exported archive", e);
        }
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exported, true);
        URI uri = exported.toURI();
        LOG.info("Webapp archive location: " + uri.toASCIIString());
        return new App(this.deploymentManager, (AppProvider)this, uri.toASCIIString());
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource((String)app.getOriginId());
        File file = resource.getFile();
        if (!resource.exists()) {
            throw new IllegalStateException("App resouce does not exist " + resource);
        }
        String context = file.getName();
        if (!FileID.isWebArchiveFile((File)file)) {
            throw new IllegalStateException("unable to create ContextHandler for " + app);
        }
        context = context.substring(0, context.length() - 4);
        if (context.endsWith("/") && context.length() > 0) {
            context = context.substring(0, context.length() - 1);
        }
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setDisplayName(context);
        webAppContext.setLogUrlOnStart(true);
        if (context.equalsIgnoreCase("root")) {
            context = "/";
        } else if (context.toLowerCase(Locale.ENGLISH).startsWith("root-")) {
            int dash = context.toLowerCase(Locale.ENGLISH).indexOf(45);
            String virtual = context.substring(dash + 1);
            webAppContext.setVirtualHosts(new String[]{virtual});
            context = "/";
        }
        if (context.charAt(0) != '/') {
            context = "/" + context;
        }
        webAppContext.setContextPath(context);
        webAppContext.setWar(file.getAbsolutePath());
        if (this.config.hasDefaultsDescriptor()) {
            webAppContext.setDefaultsDescriptor(this.config.getDefaultsDescriptor().toASCIIString());
        }
        webAppContext.setExtractWAR(true);
        webAppContext.setParentLoaderPriority(this.config.getClassloaderBehavior() == JettyEmbeddedConfiguration.ClassLoaderBehavior.JAVA_SPEC);
        if (this.config.getTempDirectory() != null) {
            webAppContext.setAttribute("org.eclipse.jetty.webapp.basetempdir", (Object)this.config.getTempDirectory());
        }
        return webAppContext;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    static {
        File targetDir;
        File baseDir;
        LOG = Logger.getLogger(ArquillianAppProvider.class.getName());
        File systemDefaultTmpDir = new File(AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.io.tmpdir");
            }
        }));
        String baseDirVal = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("basedir");
            }
        });
        File mavenTmpDir = null;
        if (baseDirVal != null && (baseDir = new File(baseDirVal)).exists() && baseDir.isDirectory() && (targetDir = new File(baseDir, "target")).exists() && targetDir.isDirectory()) {
            mavenTmpDir = new File(targetDir, "arquillian-jetty-temp");
            mavenTmpDir.mkdirs();
        }
        if (!(EXPORT_DIR = mavenTmpDir != null && mavenTmpDir.exists() && mavenTmpDir.isDirectory() ? mavenTmpDir : systemDefaultTmpDir).exists() || !EXPORT_DIR.isDirectory()) {
            throw new IllegalStateException("Could not obtain export directory \"" + EXPORT_DIR.getAbsolutePath() + "\"");
        }
    }
}

