/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import javax.annotation.concurrent.NotThreadSafe;
import org.javersion.util.Merger;

@NotThreadSafe
public final class UpdateContext<T>
implements Merger<T> {
    private UncommittedContext<T> context;

    public UpdateContext() {
        this(1, null);
    }

    public UpdateContext(int expectedUpdates) {
        this(expectedUpdates, null);
    }

    public UpdateContext(int expectedUpdates, Merger<T> merger) {
        this.context = new UncommittedContext<T>(expectedUpdates, merger);
    }

    public void merger(Merger<T> merger) {
        ((UncommittedContext)this.context).merger = merger;
    }

    public int expectedUpdates() {
        return ((UncommittedContext)this.context).expectedUpdates;
    }

    public void commit() {
        this.context = null;
    }

    public boolean isCommitted() {
        return this.context == null;
    }

    public boolean isSameAs(UpdateContext<?> other) {
        return this.context != null && this.context == other.context;
    }

    public void validate() {
        if (this.isCommitted()) {
            throw new IllegalStateException("This update is already committed");
        }
    }

    public boolean hasChanged() {
        return ((UncommittedContext)this.context).change != 0;
    }

    public int getChangeAndReset() {
        return this.context.getChangeAndReset();
    }

    @Override
    public void insert(T newEntry) {
        this.context.insert(newEntry);
    }

    @Override
    public boolean merge(T oldEntry, T newEntry) {
        return this.context.merge(oldEntry, newEntry);
    }

    @Override
    public void delete(T oldEntry) {
        this.context.delete(oldEntry);
    }

    private static final class UncommittedContext<T> {
        private int expectedUpdates;
        private Merger<T> merger;
        private int change = 0;

        UncommittedContext(int expectedUpdates, Merger<T> merger) {
            this.expectedUpdates = expectedUpdates;
            this.merger = merger;
        }

        int getChangeAndReset() {
            try {
                int n = this.change;
                return n;
            }
            finally {
                this.change = 0;
            }
        }

        void insert(T newEntry) {
            this.change = 1;
            if (this.merger != null) {
                this.merger.insert(newEntry);
            }
        }

        boolean merge(T oldEntry, T newEntry) {
            return this.merger == null ? true : this.merger.merge(oldEntry, newEntry);
        }

        void delete(T oldEntry) {
            this.change = -1;
            if (this.merger != null) {
                this.merger.delete(oldEntry);
            }
        }
    }
}

