/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.javersion.util.AbstractRedBlackTree;
import org.javersion.util.ImmutableSet;
import org.javersion.util.MutableSet;
import org.javersion.util.PersistentSet;
import org.javersion.util.UpdateContext;

@Immutable
public class PersistentTreeSet<E>
extends AbstractRedBlackTree<E, Node<E>, PersistentTreeSet<E>>
implements PersistentSet<E> {
    private static final PersistentTreeSet EMPTY = new PersistentTreeSet();
    private static final Function GET_ELEMENT = input -> input != null ? ((Node)input).getKey() : null;
    private final Node<E> root;
    private final int size;

    public static <E> PersistentTreeSet<E> empty() {
        return EMPTY;
    }

    public static <E> PersistentTreeSet<E> empty(Comparator<? super E> comparator) {
        return new PersistentTreeSet<E>(comparator);
    }

    public static <E extends Comparable<? super E>> PersistentTreeSet<E> of(E ... elements) {
        return new PersistentTreeSet<E>().conjAll((Collection)Arrays.asList(elements));
    }

    public static <E> PersistentTreeSet<E> of(Comparator<? super E> comparator, E ... elements) {
        return new PersistentTreeSet<E>(comparator).conjAll((Collection)Arrays.asList(elements));
    }

    private PersistentTreeSet() {
        this.root = null;
        this.size = 0;
    }

    private PersistentTreeSet(Comparator<? super E> comparator) {
        super(comparator);
        this.root = null;
        this.size = 0;
    }

    private PersistentTreeSet(Comparator<? super E> comparator, Node<E> root, int size) {
        super(comparator);
        this.root = root;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object key) {
        return this.find(this.root, key) != null;
    }

    Node<E> root() {
        return this.root;
    }

    @Override
    public Set<E> asSet() {
        return new ImmutableSet(this);
    }

    @Override
    public PersistentTreeSet<E> conj(E value) {
        UpdateContext context = new UpdateContext(1);
        return (PersistentTreeSet)this.doAdd(context, this.root, new Node<E>(context, value, AbstractRedBlackTree.Color.RED));
    }

    @Override
    public PersistentTreeSet<E> conjAll(Collection<? extends E> coll) {
        UpdateContext context = new UpdateContext(32);
        return (PersistentTreeSet)this.doAddAll(context, this.root, Iterables.transform(coll, new EntryToNode(context)));
    }

    @Override
    public PersistentTreeSet<E> disj(Object keyObj) {
        return (PersistentTreeSet)this.doRemove(new UpdateContext(1), this.root, keyObj);
    }

    @Override
    public MutableSet<E> toMutableSet() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.doIterator(this.root, true), (Function)GET_ELEMENT);
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.root != null) {
            return new ElementSpliterator<E>(this.root, this.size, this.comparator);
        }
        return Spliterators.emptySpliterator();
    }

    @Override
    protected PersistentTreeSet<E> doReturn(Comparator<? super E> comparator, Node<E> newRoot, int newSize) {
        if (newRoot == this.root) {
            return this;
        }
        if (newRoot == null) {
            return EMPTY;
        }
        return new PersistentTreeSet<E>(comparator, newRoot, newSize);
    }

    public String toString() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    static class ElementSpliterator<E>
    extends AbstractRedBlackTree.RBSpliterator<E, Node<E>> {
        private final Comparator<? super E> comparator;

        public ElementSpliterator(Node<E> root, int size, Comparator<? super E> comparator) {
            super(root, size, 1029);
            this.comparator = comparator;
        }

        protected ElementSpliterator(int sizeEstimate, Comparator<? super E> comparator) {
            super(sizeEstimate, 1029);
            this.comparator = comparator;
        }

        @Override
        protected AbstractRedBlackTree.RBSpliterator<E, Node<E>> newSpliterator(int sizeEstimate) {
            return new ElementSpliterator<E>(sizeEstimate, this.comparator);
        }

        @Override
        protected E apply(Node<E> node) {
            return (E)node.key;
        }

        @Override
        public Comparator<? super E> getComparator() {
            return this.comparator;
        }
    }

    static class Node<E>
    extends AbstractRedBlackTree.Node<E, Node<E>> {
        public Node(UpdateContext<? super Node<E>> context, E key, AbstractRedBlackTree.Color color) {
            this(context, key, color, null, null);
        }

        public Node(UpdateContext<? super Node<E>> context, E key, AbstractRedBlackTree.Color color, Node<E> left, Node<E> right) {
            super(context, key, color, left, right);
        }

        public E getKey() {
            return (E)this.key;
        }

        @Override
        public Node<E> self() {
            return this;
        }

        @Override
        protected Node<E> cloneWith(UpdateContext<? super Node<E>> currentContext) {
            return new Node<Object>(currentContext, this.key, this.color, (Node)this.left, (Node)this.right);
        }

        @Override
        protected Node<E> replaceWith(UpdateContext<? super Node<E>> currentContext, Node<E> node) {
            return this;
        }
    }

    private static final class EntryToNode<E>
    implements Function<E, Node<E>> {
        private final UpdateContext<Node<E>> context;

        private EntryToNode(UpdateContext<Node<E>> context) {
            this.context = context;
        }

        public Node<E> apply(E input) {
            return new Node<E>(this.context, input, AbstractRedBlackTree.Color.RED);
        }
    }
}

