/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.javersion.util.AbstractTreeMap;
import org.javersion.util.ImmutableMap;
import org.javersion.util.MutableTreeMap;
import org.javersion.util.PersistentSortedMap;

@Immutable
public class PersistentTreeMap<K, V>
extends AbstractTreeMap<K, V, PersistentTreeMap<K, V>>
implements PersistentSortedMap<K, V> {
    public static final PersistentTreeMap EMPTY = new PersistentTreeMap();
    private final AbstractTreeMap.Node<K, V> root;
    private final int size;

    public static <K, V> PersistentTreeMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> PersistentTreeMap<K, V> empty(Comparator<? super K> comparator) {
        return new PersistentTreeMap<K, V>(comparator);
    }

    public static <K, V> PersistentTreeMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        return (PersistentTreeMap)EMPTY.assocAll(map);
    }

    public static <K, V> PersistentTreeMap<K, V> of() {
        return PersistentTreeMap.empty();
    }

    public static <K, V> PersistentTreeMap<K, V> of(K k1, V v1) {
        return (PersistentTreeMap)EMPTY.assoc(k1, v1);
    }

    public static <K, V> PersistentTreeMap<K, V> of(K k1, V v1, K k2, V v2) {
        MutableTreeMap<K, V> map = new MutableTreeMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map.toPersistentMap();
    }

    public static <K, V> PersistentTreeMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableTreeMap<K, V> map = new MutableTreeMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map.toPersistentMap();
    }

    private PersistentTreeMap() {
        this.root = null;
        this.size = 0;
    }

    private PersistentTreeMap(Comparator<? super K> comparator) {
        super(comparator);
        this.root = null;
        this.size = 0;
    }

    PersistentTreeMap(Comparator<? super K> comparator, AbstractTreeMap.Node<K, V> root, int size) {
        super(comparator);
        this.root = root;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected AbstractTreeMap.Node<K, V> root() {
        return this.root;
    }

    @Override
    public MutableTreeMap<K, V> toMutableMap() {
        return new MutableTreeMap<K, V>(this.comparator, this.root, this.size);
    }

    @Override
    public Map<K, V> asMap() {
        return new ImmutableMap(this);
    }

    @Override
    protected PersistentTreeMap<K, V> doReturn(Comparator<? super K> comparator, AbstractTreeMap.Node<K, V> newRoot, int newSize) {
        if (newRoot == null) {
            return EMPTY;
        }
        return new PersistentTreeMap<K, V>(comparator, newRoot, newSize);
    }

    @Override
    public Map.Entry<K, V> getFirstEntry() {
        return this.findMin(this.root);
    }

    @Override
    public Map.Entry<K, V> getLastEntry() {
        return this.findMax(this.root);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.higherNode(this.root, key);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.ceilingNode(this.root, key);
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.lowerNode(this.root, key);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.floorNode(this.root, key);
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        if (this.root != null) {
            return new AbstractTreeMap.EntrySpliterator<K, V>(this.root, this.size, this.comparator, true);
        }
        return Spliterators.emptySpliterator();
    }

    @Override
    public Spliterator<K> keySpliterator() {
        if (this.root != null) {
            return new AbstractTreeMap.KeySpliterator<K, V>(this.root, this.size, this.comparator, true);
        }
        return Spliterators.emptySpliterator();
    }

    @Override
    public Spliterator<V> valueSpliterator() {
        if (this.root != null) {
            return new AbstractTreeMap.ValueSpliterator<K, V>(this.root, this.size, this.comparator, true);
        }
        return Spliterators.emptySpliterator();
    }

    public String toString() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(", ", "{", "}"));
    }
}

