/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.javersion.util.AbstractHashTrie;
import org.javersion.util.AbstractTrieSet;
import org.javersion.util.ImmutableSet;
import org.javersion.util.MutableHashSet;
import org.javersion.util.PersistentSet;

@Immutable
public class PersistentHashSet<E>
extends AbstractTrieSet<E, PersistentHashSet<E>>
implements PersistentSet<E> {
    private final AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> root;
    private final int size;

    public PersistentHashSet() {
        this(null, 0);
    }

    PersistentHashSet(AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> root, int size) {
        this.root = root != null ? root : EMPTY_NODE;
        this.size = size;
    }

    @Override
    public MutableHashSet<E> toMutableSet() {
        return new MutableHashSet<E>(this.root, this.size);
    }

    @Override
    public ImmutableSet<E> asSet() {
        return new ImmutableSet(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Spliterator<E> spliterator() {
        return new AbstractTrieSet.ElementSpliterator<E>(this.root, this.size, true);
    }

    @Override
    protected PersistentHashSet<E> doReturn(AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> newRoot, int newSize) {
        if (newRoot == this.root) {
            return this;
        }
        return new PersistentHashSet<E>(newRoot, newSize);
    }

    @Override
    protected AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> root() {
        return this.root;
    }

    public String toString() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
    }
}

