/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.javersion.util.AbstractHashMap;
import org.javersion.util.AbstractHashTrie;
import org.javersion.util.ImmutableMap;
import org.javersion.util.MutableHashMap;
import org.javersion.util.PersistentMap;

@Immutable
public class PersistentHashMap<K, V>
extends AbstractHashMap<K, V, PersistentHashMap<K, V>>
implements PersistentMap<K, V> {
    private static final PersistentHashMap EMPTY_MAP = new PersistentHashMap(EMPTY_NODE, 0);
    private final AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> root;
    private final int size;

    public static <K, V> PersistentHashMap<K, V> empty() {
        return EMPTY_MAP;
    }

    public static <K, V> PersistentHashMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        return (PersistentHashMap)EMPTY_MAP.assocAll(map);
    }

    public static <K, V> PersistentHashMap<K, V> of() {
        return PersistentHashMap.empty();
    }

    public static <K, V> PersistentHashMap<K, V> of(K k1, V v1) {
        return (PersistentHashMap)EMPTY_MAP.assoc(k1, v1);
    }

    public static <K, V> PersistentHashMap<K, V> of(K k1, V v1, K k2, V v2) {
        MutableHashMap<K, V> map = new MutableHashMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map.toPersistentMap();
    }

    public static <K, V> PersistentHashMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableHashMap<K, V> map = new MutableHashMap<K, V>(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map.toPersistentMap();
    }

    static <K, V> PersistentHashMap<K, V> create(AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> newRoot, int newSize) {
        return newRoot == null ? EMPTY_MAP : new PersistentHashMap<K, V>(newRoot, newSize);
    }

    private PersistentHashMap(AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> newRoot, int newSize) {
        this.root = newRoot;
        this.size = newSize;
    }

    @Override
    public MutableHashMap<K, V> toMutableMap() {
        return new MutableHashMap<K, V>(this.root, this.size);
    }

    @Override
    public Map<K, V> asMap() {
        return new ImmutableMap(this);
    }

    @Override
    protected AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> root() {
        return this.root;
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return new AbstractHashMap.EntrySpliterator<K, V>(this.root, this.size, true);
    }

    @Override
    public Spliterator<K> keySpliterator() {
        return new AbstractHashMap.KeySpliterator<K, V>(this.root, this.size, true);
    }

    @Override
    public Spliterator<V> valueSpliterator() {
        return new AbstractHashMap.ValueSpliterator<K, V>(this.root, this.size, true);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected PersistentHashMap<K, V> doReturn(AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> newRoot, int newSize) {
        if (newRoot == this.root) {
            return this;
        }
        return PersistentHashMap.create(newRoot, newSize);
    }

    public String toString() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(", ", "{", "}"));
    }
}

