/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import javax.annotation.concurrent.NotThreadSafe;
import org.javersion.util.AbstractTreeMap;
import org.javersion.util.Merger;
import org.javersion.util.MutableSortedMap;
import org.javersion.util.PersistentTreeMap;
import org.javersion.util.UpdateContext;

@NotThreadSafe
public class MutableTreeMap<K, V>
extends AbstractMap<K, V>
implements MutableSortedMap<K, V> {
    private MMap<K, V> map;
    private V previousValue;
    private final Merger<Map.Entry<K, V>> defaultMerger = new Merger<Map.Entry<K, V>>(){

        @Override
        public void insert(Map.Entry<K, V> newEntry) {
            MutableTreeMap.this.previousValue = null;
        }

        @Override
        public boolean merge(Map.Entry<K, V> oldEntry, Map.Entry<K, V> newEntry) {
            MutableTreeMap.this.previousValue = oldEntry.getValue();
            return true;
        }

        @Override
        public void delete(Map.Entry<K, V> oldEntry) {
            MutableTreeMap.this.previousValue = oldEntry.getValue();
        }
    };

    public MutableTreeMap() {
        this.map = new MMap();
    }

    public MutableTreeMap(Comparator<? super K> comparator) {
        this.map = new MMap(comparator);
    }

    MutableTreeMap(Comparator<? super K> comparator, AbstractTreeMap.Node<K, V> root, int size) {
        this.map = new MMap(comparator, root, size);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    AbstractTreeMap.Node<K, V> root() {
        return ((MMap)this.map).root;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return MutableTreeMap.this.map.iterator();
            }

            @Override
            public int size() {
                return MutableTreeMap.this.map.size();
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return new AbstractTreeMap.EntrySpliterator(MutableTreeMap.this.map.root, MutableTreeMap.this.map.size(), ((MutableTreeMap)MutableTreeMap.this).map.comparator, false);
            }
        };
    }

    @Override
    public V put(K key, V value) {
        this.map.merge(key, value, this.defaultMerger);
        return this.previousValue;
    }

    @Override
    public V remove(Object key) {
        this.map.dissoc(key, this.defaultMerger);
        return this.previousValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.assocAll(m);
    }

    @Override
    public void clear() {
        this.map = new MMap(this.map.comparator);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.map.iterator();
    }

    @Override
    public void merge(K key, V value, Merger<Map.Entry<K, V>> merger) {
        this.map.merge(key, value, merger);
    }

    @Override
    public void mergeAll(Map<? extends K, ? extends V> m, Merger<Map.Entry<K, V>> merger) {
        this.map.mergeAll(m, merger);
    }

    @Override
    public void mergeAll(Iterable<Map.Entry<K, V>> entries, Merger<Map.Entry<K, V>> merger) {
        this.map.mergeAll(entries, merger);
    }

    @Override
    public PersistentTreeMap<K, V> toPersistentMap() {
        return this.map.toPersistentMap();
    }

    private static class MMap<K, V>
    extends AbstractTreeMap<K, V, MMap<K, V>> {
        private final Thread owner = Thread.currentThread();
        private UpdateContext<Map.Entry<K, V>> updateContext;
        private AbstractTreeMap.Node<K, V> root;
        private int size;

        private MMap() {
            this.root = null;
            this.size = 0;
            this.updateContext = new UpdateContext();
        }

        private MMap(Comparator<? super K> comparator) {
            this(comparator, null, 0);
        }

        private MMap(Comparator<? super K> comparator, AbstractTreeMap.Node<K, V> root, int size) {
            super(comparator);
            this.updateContext = new UpdateContext();
            this.root = root;
            this.size = size;
        }

        @Override
        protected AbstractTreeMap.Node<K, V> root() {
            this.verifyThread();
            return this.root;
        }

        @Override
        protected MMap<K, V> self() {
            return this;
        }

        public PersistentTreeMap<K, V> toPersistentMap() {
            this.verifyThread();
            this.updateContext.commit();
            return new PersistentTreeMap<K, V>(this.comparator, this.root, this.size);
        }

        private void verifyThread() {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException("MutableMap should only be accessed form the thread it was created in.");
            }
        }

        @Override
        public int size() {
            this.verifyThread();
            return this.size;
        }

        @Override
        protected MMap<K, V> doReturn(Comparator<? super K> comparator, AbstractTreeMap.Node<K, V> newRoot, int newSize) {
            this.root = newRoot;
            this.size = newSize;
            return this;
        }

        @Override
        protected UpdateContext<Map.Entry<K, V>> updateContext(Merger<Map.Entry<K, V>> merger) {
            this.verifyThread();
            if (this.updateContext.isCommitted()) {
                this.updateContext = new UpdateContext<Map.Entry<K, V>>(32, merger);
            } else {
                this.updateContext.validate();
                this.updateContext.merger(merger);
            }
            return this.updateContext;
        }

        @Override
        protected void commit(UpdateContext<?> updateContext) {
        }
    }
}

