/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import java.util.AbstractSet;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;
import org.javersion.util.AbstractHashTrie;
import org.javersion.util.AbstractTrieSet;
import org.javersion.util.Merger;
import org.javersion.util.MutableSet;
import org.javersion.util.PersistentHashSet;
import org.javersion.util.UpdateContext;

@NotThreadSafe
public class MutableHashSet<E>
extends AbstractSet<E>
implements MutableSet<E> {
    private MSet<E> set;

    public MutableHashSet() {
        this.set = new MSet(32);
    }

    public MutableHashSet(int expectedSize) {
        this.set = new MSet(expectedSize);
    }

    MutableHashSet(AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> root, int size) {
        this.set = new MSet(root, size);
    }

    @Override
    public boolean add(E e) {
        int size = ((MSet)this.set).size;
        this.set.conj(e);
        return size != ((MSet)this.set).size;
    }

    @Override
    public boolean addAllFrom(Iterable<E> iterable) {
        int size = ((MSet)this.set).size;
        this.set.conjAll(iterable);
        return size != ((MSet)this.set).size;
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean remove(Object o) {
        int size = ((MSet)this.set).size;
        this.set.disj(o);
        return size != ((MSet)this.set).size;
    }

    @Override
    public void clear() {
        if (this.set.size() > 0) {
            this.set = new MSet(32);
        }
    }

    @Override
    public PersistentHashSet<E> toPersistentSet() {
        return this.set.toPersistentSet();
    }

    private static class MSet<E>
    extends AbstractTrieSet<E, MSet<E>> {
        private final Thread owner = Thread.currentThread();
        private UpdateContext<AbstractTrieSet.EntryNode<E>> updateContext;
        private AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> root;
        private int size;

        private MSet(int expectedSize) {
            this(expectedSize, null, 0);
        }

        private MSet(AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> root, int size) {
            this(32, root, size);
        }

        private MSet(int expectedSize, AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> root, int size) {
            this.updateContext = new UpdateContext(expectedSize);
            this.root = root != null ? root : EMPTY_NODE;
            this.size = size;
        }

        public PersistentHashSet<E> toPersistentSet() {
            this.verifyThread();
            this.updateContext.commit();
            return new PersistentHashSet<E>(this.root, this.size);
        }

        private void verifyThread() {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException("MutableMap should only be accessed form the thread it was created in.");
            }
        }

        @Override
        public int size() {
            this.verifyThread();
            return this.size;
        }

        @Override
        protected MSet<E> doReturn(AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> newRoot, int newSize) {
            this.verifyThread();
            this.root = newRoot != null ? newRoot : EMPTY_NODE;
            this.size = newSize;
            return this;
        }

        @Override
        protected AbstractHashTrie.Node<E, AbstractTrieSet.EntryNode<E>> root() {
            return this.root;
        }

        @Override
        protected UpdateContext<AbstractTrieSet.EntryNode<E>> updateContext(int expectedUpdates, Merger<AbstractTrieSet.EntryNode<E>> merger) {
            this.verifyThread();
            if (this.updateContext.isCommitted()) {
                this.updateContext = new UpdateContext<AbstractTrieSet.EntryNode<E>>(expectedUpdates, merger);
            } else {
                this.updateContext.merger(merger);
            }
            return this.updateContext;
        }

        @Override
        protected void commit(UpdateContext<?> updateContext) {
        }
    }
}

