/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.javersion.util.AbstractHashMap;
import org.javersion.util.AbstractHashTrie;
import org.javersion.util.Merger;
import org.javersion.util.MutableMap;
import org.javersion.util.PersistentHashMap;
import org.javersion.util.UpdateContext;

@NotThreadSafe
public class MutableHashMap<K, V>
extends AbstractMap<K, V>
implements MutableMap<K, V> {
    private MMap<K, V> map;
    private V previousValue;
    private final Merger<Map.Entry<K, V>> defaultMerger = new Merger<Map.Entry<K, V>>(){

        @Override
        public void insert(Map.Entry<K, V> newEntry) {
            MutableHashMap.this.previousValue = null;
        }

        @Override
        public boolean merge(Map.Entry<K, V> oldEntry, Map.Entry<K, V> newEntry) {
            MutableHashMap.this.previousValue = oldEntry.getValue();
            return true;
        }

        @Override
        public void delete(Map.Entry<K, V> oldEntry) {
            MutableHashMap.this.previousValue = oldEntry.getValue();
        }
    };

    public MutableHashMap() {
        this.map = new MMap();
    }

    public MutableHashMap(int expectedSize) {
        this.map = new MMap(expectedSize);
    }

    MutableHashMap(AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> root, int size) {
        this.map = new MMap(root, size);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return MutableHashMap.this.map.iterator();
            }

            @Override
            public int size() {
                return MutableHashMap.this.map.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        this.map.merge(key, value, this.defaultMerger);
        return this.previousValue;
    }

    @Override
    public V remove(Object key) {
        this.map.dissoc(key, this.defaultMerger);
        return this.previousValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.assocAll(m);
    }

    @Override
    public void clear() {
        if (this.map.size() > 0) {
            this.map = new MMap();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.map.iterator();
    }

    @Override
    public void merge(K key, V value, Merger<Map.Entry<K, V>> merger) {
        this.map.merge(key, value, merger);
    }

    @Override
    public void mergeAll(Map<? extends K, ? extends V> m, Merger<Map.Entry<K, V>> merger) {
        this.map.mergeAll(m, merger);
    }

    @Override
    public void mergeAll(Iterable<Map.Entry<K, V>> entries, Merger<Map.Entry<K, V>> merger) {
        this.map.mergeAll(entries, merger);
    }

    @Override
    public PersistentHashMap<K, V> toPersistentMap() {
        return this.map.toPersistentMap();
    }

    private static class MMap<K, V>
    extends AbstractHashMap<K, V, MMap<K, V>> {
        private final Thread owner = Thread.currentThread();
        private UpdateContext<Map.Entry<K, V>> updateContext;
        private AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> root;
        private int size;

        private MMap(int expectedSize) {
            this(expectedSize, EMPTY_NODE, 0);
        }

        private MMap() {
            this(EMPTY_NODE, 0);
        }

        private MMap(AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> root, int size) {
            this(32, root, size);
        }

        private MMap(int expectedSize, AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> root, int size) {
            this.updateContext = new UpdateContext(expectedSize);
            this.root = root;
            this.size = size;
        }

        @Override
        protected AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> root() {
            this.verifyThread();
            return this.root;
        }

        @Override
        protected MMap<K, V> self() {
            return this;
        }

        public PersistentHashMap<K, V> toPersistentMap() {
            this.verifyThread();
            this.updateContext.commit();
            return PersistentHashMap.create(this.root, this.size);
        }

        private void verifyThread() {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException("MutableMap should only be accessed form the thread it was created in.");
            }
        }

        @Override
        public int size() {
            this.verifyThread();
            return this.size;
        }

        @Override
        protected MMap<K, V> doReturn(AbstractHashTrie.Node<K, AbstractHashMap.EntryNode<K, V>> newRoot, int newSize) {
            this.root = newRoot == null ? EMPTY_NODE : newRoot;
            this.size = newSize;
            return this;
        }

        @Override
        protected UpdateContext<Map.Entry<K, V>> updateContext(int expectedUpdates, Merger<Map.Entry<K, V>> merger) {
            this.verifyThread();
            if (this.updateContext.isCommitted()) {
                this.updateContext = new UpdateContext<Map.Entry<K, V>>(expectedUpdates, merger);
            } else {
                this.updateContext.validate();
                this.updateContext.merger(merger);
            }
            return this.updateContext;
        }

        @Override
        protected void commit(UpdateContext<?> updateContext) {
        }
    }
}

