/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.javersion.util.Check;
import org.javersion.util.PersistentMap;

@Immutable
class ImmutableMap<K, V>
extends AbstractMap<K, V> {
    private final PersistentMap<K, V> map;

    ImmutableMap(PersistentMap<K, V> map) {
        this.map = Check.notNull(map, "map");
    }

    public PersistentMap<K, V> getPersistentMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return ImmutableMap.this.map.iterator();
            }

            @Override
            public int size() {
                return ImmutableMap.this.map.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

