/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;

public class Check {
    private static final String NOT_NULL_OR_EMPTY_FMT = "%s shoud not be null or empty. Got %s";

    public static <T> T notNull(T reference, String fieldName) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("%s should not be null", fieldName));
        }
        return reference;
    }

    public static <T> T notNull$(T reference, String messageFormat, Object ... args) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format(messageFormat, args));
        }
        return reference;
    }

    public static void that(boolean expression, String messageFormat, Object ... args) {
        Preconditions.checkArgument((boolean)expression, (String)messageFormat, (Object[])args);
    }

    public static <T extends Iterable<?>> T notNullOrEmpty(T reference, String fieldName) {
        return Check.notNullOrEmpty$(reference, NOT_NULL_OR_EMPTY_FMT, new Object[]{fieldName, reference});
    }

    public static <T extends Iterable<?>> T notNullOrEmpty$(T reference, String messageFormat, Object ... args) {
        Preconditions.checkArgument((reference != null && reference.iterator().hasNext() ? 1 : 0) != 0, (String)messageFormat, (Object[])args);
        return reference;
    }

    public static <T extends Collection<?>> T notNullOrEmpty(T reference, String fieldName) {
        return Check.notNullOrEmpty$(reference, NOT_NULL_OR_EMPTY_FMT, new Object[]{fieldName, reference});
    }

    public static <T extends Collection<?>> T notNullOrEmpty$(T reference, String messageFormat, Object ... args) {
        Preconditions.checkArgument((reference != null && !reference.isEmpty() ? 1 : 0) != 0, (String)messageFormat, (Object[])args);
        return reference;
    }

    public static <K, V, T extends Map<K, V>> T notNullOrEmpty(T reference, String fieldName) {
        return Check.notNullOrEmpty$(reference, NOT_NULL_OR_EMPTY_FMT, fieldName, reference);
    }

    public static <K, V, T extends Map<K, V>> T notNullOrEmpty$(T reference, String messageFormat, Object ... args) {
        Preconditions.checkArgument((reference != null && !reference.isEmpty() ? 1 : 0) != 0, (String)messageFormat, (Object[])args);
        return reference;
    }

    public static String notNullOrEmpty(String reference, String fieldName) {
        if (reference == null || reference.length() == 0) {
            throw new IllegalArgumentException(String.format(NOT_NULL_OR_EMPTY_FMT, fieldName, reference));
        }
        return reference;
    }

    public static String notNullOrEmpty$(String reference, String messageFormat, Object ... args) {
        Preconditions.checkArgument((reference != null && reference.length() != 0 ? 1 : 0) != 0, (String)messageFormat, (Object[])args);
        return reference;
    }
}

