/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
abstract class Bytes {
    static final int BYTE_MASK = 255;

    Bytes() {
    }

    abstract int getNumber(int var1, int var2);

    abstract void setNumber(int var1, int var2, int var3);

    abstract int length();

    static class Long
    extends Bytes {
        private long l;

        Long(long l) {
            this.l = l;
        }

        Long(int i1, int i2) {
            this.l = (long)i1 << 32 | (long)i2;
        }

        @Override
        int getNumber(int index, int encodingBitLen) {
            long number = this.l;
            int shift = 64 - encodingBitLen - index;
            if (shift > 0) {
                number >>>= shift;
            } else if (shift < 0) {
                number <<= -shift;
            }
            return (int)(number & (long)((1 << encodingBitLen) - 1));
        }

        @Override
        void setNumber(int number, int index, int encodingBitLen) {
            int shift = 64 - encodingBitLen - index;
            this.l = shift > 0 ? (this.l |= (long)number << shift) : (this.l |= (long)(number >>> -shift));
        }

        @Override
        int length() {
            return 8;
        }

        long getLong() {
            return this.l;
        }
    }

    static class Integer
    extends Bytes {
        private int i;

        Integer() {
            this(0);
        }

        Integer(int i) {
            this.i = i;
        }

        @Override
        int getNumber(int index, int encodingBitLen) {
            int number = this.i;
            int shift = 32 - encodingBitLen - index;
            if (shift > 0) {
                number >>>= shift;
            } else if (shift < 0) {
                number <<= -shift;
            }
            return number & (1 << encodingBitLen) - 1;
        }

        @Override
        void setNumber(int number, int index, int encodingBitLen) {
            int shift = 32 - encodingBitLen - index;
            this.i = shift > 0 ? (this.i |= number << shift) : (this.i |= number >>> -shift);
        }

        @Override
        int length() {
            return 4;
        }

        int getInt() {
            return this.i;
        }
    }

    static class Array
    extends Bytes {
        private final byte[] bytes;

        Array(int length) {
            this(new byte[length]);
        }

        Array(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        int getNumber(int index, int encodingBitLen) {
            int number;
            int hiByte = (index + encodingBitLen - 1) / 8;
            int shift = (index + encodingBitLen) % 8;
            if (shift == 0) {
                number = this.bytes[hiByte];
            } else {
                number = hiByte < this.bytes.length ? (this.bytes[hiByte] & 0xFF) >>> 8 - shift : 0;
                if (shift < encodingBitLen && hiByte > 0) {
                    number |= this.bytes[hiByte - 1] << shift;
                }
            }
            return number & (1 << encodingBitLen) - 1;
        }

        @Override
        void setNumber(int number, int index, int encodingBitLen) {
            int hiByte = (index + encodingBitLen - 1) / 8;
            int shift = (index + encodingBitLen) % 8;
            if (shift == 0) {
                int n = hiByte;
                this.bytes[n] = (byte)(this.bytes[n] | number);
            } else {
                if (hiByte < this.bytes.length) {
                    int n = hiByte;
                    this.bytes[n] = (byte)(this.bytes[n] | number << 8 - shift);
                }
                if (shift < encodingBitLen && hiByte > 0) {
                    int n = hiByte - 1;
                    this.bytes[n] = (byte)(this.bytes[n] | number >>> shift);
                }
            }
        }

        @Override
        int length() {
            return this.bytes.length;
        }

        byte[] getBytes() {
            return this.bytes;
        }
    }
}

