/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import org.javersion.util.Bytes;
import org.javersion.util.Check;

@Immutable
public abstract class BinaryEncoder {
    public static final BinaryEncoder HEX;
    public static final BinaryEncoder HEX_ALIASED;
    public static final BinaryEncoder BASE32;
    public static final BinaryEncoder BASE32_CROCKFORD;
    public static final BinaryEncoder BASE32_CROCKFORD_NUMBER;
    public static final BinaryEncoder BASE64;
    public static final BinaryEncoder BASE64_URL;
    public static final BinaryEncoder NUMBER_BASE64_URL;
    protected final int encodingBitLen;
    final byte mask;
    final char[] numberToChar;
    final int[] charToNumber;

    private BinaryEncoder(char[] numberToChar, int[] charToNumber) {
        Check.notNull(numberToChar, "toChar");
        Check.notNull(charToNumber, "charToNumber");
        this.numberToChar = Arrays.copyOf(numberToChar, numberToChar.length);
        this.charToNumber = Arrays.copyOf(charToNumber, charToNumber.length);
        int radix = numberToChar.length;
        Check.that(Integer.bitCount(radix) == 1, "radix should be ^2", new Object[0]);
        Check.that(radix >= 2, "radix should be > 2", new Object[0]);
        Check.that(radix <= 256, "radix should be <= 256", new Object[0]);
        this.encodingBitLen = Integer.bitCount(radix - 1);
        this.mask = (byte)(radix - 1);
    }

    public String encode(byte[] bytes) {
        return this.encode(new Bytes.Array(bytes));
    }

    public byte[] decode(String str) {
        return this.decode(str, new Bytes.Array(str.length() * this.encodingBitLen / 8)).getBytes();
    }

    public String encodeLong(long l) {
        return this.encode(new Bytes.Long(l));
    }

    public String encodeInt(int i) {
        return this.encode(new Bytes.Integer(i));
    }

    public long decodeLong(String str) {
        return this.decode(str, new Bytes.Long(0L)).getLong();
    }

    public int decodeInt(String str) {
        return this.decode(str, new Bytes.Integer(0)).getInt();
    }

    abstract String encode(Bytes var1);

    abstract <T extends Bytes> T decode(String var1, T var2);

    void throwIllegalCharacterException(String str, int index) {
        throw new IllegalArgumentException(String.format("Illegal character %s at %s", Character.valueOf(str.charAt(index)), index));
    }

    int charLen(int byteLen) {
        return 1 + (byteLen * 8 - 1) / this.encodingBitLen;
    }

    static {
        Builder builder = new Builder("0123456789ABCDEF").withAliases("          abcdef");
        HEX = builder.buildUnsignedNumberEncoder();
        builder.withAliasesFor('0', "oO").withAliasesFor('1', "iIl");
        HEX_ALIASED = builder.buildUnsignedNumberEncoder();
        builder = new Builder("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567").withAliases("abcdefghijklmnopqrstuvwxyz");
        BASE32 = builder.buildBaseEncoder();
        builder = new Builder("0123456789ABCDEFGHJKMNPQRSTVWXYZ").withAliases("          abcdefghjkmnpqrstvwxyz").withAliasesFor('0', "oO").withAliasesFor('1', "iIlL");
        BASE32_CROCKFORD = builder.buildBaseEncoder();
        BASE32_CROCKFORD_NUMBER = builder.buildUnsignedNumberEncoder();
        builder = new Builder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        BASE64 = builder.buildBaseEncoder();
        builder = new Builder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");
        BASE64_URL = builder.buildBaseEncoder();
        builder = new Builder("-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz");
        NUMBER_BASE64_URL = builder.buildUnsignedNumberEncoder();
    }

    public static class BaseEncoder
    extends BinaryEncoder {
        private BaseEncoder(char[] numberToChar, int[] charToNumber) {
            super(numberToChar, charToNumber);
        }

        @Override
        String encode(Bytes bytes) {
            int charLen = this.charLen(bytes.length());
            char[] chars = new char[charLen];
            int bitIndex = 0;
            for (int charIndex = 0; charIndex < charLen; ++charIndex) {
                int num = bytes.getNumber(bitIndex, this.encodingBitLen);
                chars[charIndex] = this.numberToChar[num];
                bitIndex += this.encodingBitLen;
            }
            return new String(chars);
        }

        @Override
        <T extends Bytes> T decode(String str, T bytes) {
            int charLen = str.length();
            int bitIndex = 0;
            for (int charIndex = 0; charIndex < charLen; ++charIndex) {
                int number;
                char charToNumberIndex = str.charAt(charIndex);
                if (charToNumberIndex >= this.charToNumber.length) {
                    this.throwIllegalCharacterException(str, charIndex);
                }
                if ((number = this.charToNumber[charToNumberIndex]) < 0) {
                    this.throwIllegalCharacterException(str, charIndex);
                }
                bytes.setNumber(number, bitIndex, this.encodingBitLen);
                bitIndex += this.encodingBitLen;
            }
            return bytes;
        }
    }

    public static class SignedNumberEncoder
    extends NumberEncoder {
        private SignedNumberEncoder(char[] numberToChar, int[] charToNumber) {
            super(numberToChar, charToNumber);
        }

        @Override
        public String encodeLong(long l) {
            return super.encodeLong(l - Long.MIN_VALUE);
        }

        @Override
        public String encodeInt(int i) {
            return super.encodeInt(i - Integer.MIN_VALUE);
        }

        @Override
        public long decodeLong(String str) {
            return super.decodeLong(str) + Long.MIN_VALUE;
        }

        @Override
        public int decodeInt(String str) {
            return super.decodeInt(str) + Integer.MIN_VALUE;
        }
    }

    public static class NumberEncoder
    extends BinaryEncoder {
        private NumberEncoder(char[] numberToChar, int[] charToNumber) {
            super(numberToChar, charToNumber);
            for (int i = 1; i < numberToChar.length; ++i) {
                Check.that(numberToChar[i - 1] < numberToChar[i], "Expected alphabet to be in lexical order! Got %s before %s", Character.valueOf(numberToChar[i - 1]), Character.valueOf(numberToChar[i]));
            }
        }

        @Override
        String encode(Bytes bytes) {
            int charLen = this.charLen(bytes.length());
            char[] chars = new char[charLen];
            int bitIndex = bytes.length() * 8 - this.encodingBitLen;
            for (int charIndex = charLen - 1; charIndex >= 0; --charIndex) {
                int num = bytes.getNumber(bitIndex, this.encodingBitLen);
                chars[charIndex] = this.numberToChar[num];
                bitIndex -= this.encodingBitLen;
            }
            return new String(chars);
        }

        @Override
        <T extends Bytes> T decode(String str, T bytes) {
            int charLen = str.length();
            int bitIndex = bytes.length() * 8 - this.encodingBitLen;
            for (int charIndex = charLen - 1; charIndex >= 0; --charIndex) {
                int number;
                char charToNumberIndex = str.charAt(charIndex);
                if (charToNumberIndex >= this.charToNumber.length) {
                    this.throwIllegalCharacterException(str, charIndex);
                }
                if ((number = this.charToNumber[charToNumberIndex]) < 0) {
                    this.throwIllegalCharacterException(str, charIndex);
                }
                bytes.setNumber(number, bitIndex, this.encodingBitLen);
                bitIndex -= this.encodingBitLen;
            }
            return bytes;
        }
    }

    public static final class Builder {
        private int maxChar = -1;
        private final char[] numberToChar;
        private int[] charToNumber;

        public Builder(String chars) {
            this(chars.toCharArray());
        }

        public Builder(char ... chars) {
            this.numberToChar = Arrays.copyOf(chars, chars.length);
            this.setMaxChar(chars);
            this.charToNumber = new int[this.maxChar + 1];
            Arrays.fill(this.charToNumber, -1);
            int i = 0;
            while (i < chars.length) {
                char ch = chars[i];
                this.verify(ch);
                this.numberToChar[i] = ch;
                this.charToNumber[ch] = i++;
            }
        }

        public Builder withAliasesFor(char ch, String aliases) {
            return this.withAliasesFor(ch, aliases.toCharArray());
        }

        public Builder withAliasesFor(char ch, char ... aliases) {
            this.setMaxChar(aliases);
            this.ensureCharToNumberSize();
            for (int n : aliases) {
                this.verify((char)n);
                this.charToNumber[n] = n;
            }
            return this;
        }

        private void ensureCharToNumberSize() {
            int oldSize = this.charToNumber.length;
            if (oldSize <= this.maxChar) {
                this.charToNumber = Arrays.copyOf(this.charToNumber, this.maxChar + 1);
            }
            Arrays.fill(this.charToNumber, oldSize, this.charToNumber.length, -1);
        }

        public Builder withAliases(String aliases) {
            Check.that(aliases.length() <= this.numberToChar.length, "Expected positional aliases length to be same or less as main chars. Use space to skip.", new Object[0]);
            char[] chars = aliases.toCharArray();
            this.setMaxChar(chars);
            this.ensureCharToNumberSize();
            for (int i = 0; i < chars.length; ++i) {
                char alias = chars[i];
                if (alias == ' ') continue;
                this.verify(alias);
                this.charToNumber[alias] = i;
            }
            return this;
        }

        public NumberEncoder buildUnsignedNumberEncoder() {
            return new NumberEncoder(this.numberToChar, this.charToNumber);
        }

        public NumberEncoder buildSignedNumberEncoder() {
            return new SignedNumberEncoder(this.numberToChar, this.charToNumber);
        }

        public BaseEncoder buildBaseEncoder() {
            return new BaseEncoder(this.numberToChar, this.charToNumber);
        }

        private void verify(char ch) {
            Check.that(this.charToNumber[ch] == -1, "Duplicate mapping for %s", Character.valueOf(ch));
        }

        private void setMaxChar(char[] chars) {
            for (int i = 0; i < chars.length; ++i) {
                int ch = chars[i];
                if (this.maxChar >= ch) continue;
                this.maxChar = ch;
            }
        }
    }
}

