/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import org.javersion.util.AbstractHashTrie;
import org.javersion.util.Merger;
import org.javersion.util.UpdateContext;

public abstract class AbstractTrieSet<E, This extends AbstractTrieSet<E, This>>
extends AbstractHashTrie<E, EntryNode<E>, This>
implements Iterable<E> {
    private static final Function ELEMENT_TO_ENTRY = new Function(){

        public EntryNode apply(Object input) {
            return new EntryNode<Object>(input);
        }
    };
    private static final Function ENTRY_TO_ELEMENT = input -> input != null ? ((EntryNode)input).element() : null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public This conj(E element) {
        UpdateContext<EntryNode<E>> updateContext = this.updateContext(1, null);
        try {
            AbstractTrieSet abstractTrieSet = (AbstractTrieSet)this.doAdd(updateContext, new EntryNode<E>(element));
            return (This)abstractTrieSet;
        }
        finally {
            this.commit(updateContext);
        }
    }

    public This conjAll(Collection<? extends E> elements) {
        return this.conjAll(elements, elements.size());
    }

    public This conjAll(AbstractTrieSet<? extends E, ?> elements) {
        return this.conjAll(elements, elements.size());
    }

    public This conjAll(Iterable<? extends E> elements) {
        return this.conjAll(elements, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private This conjAll(Iterable<? extends E> elements, int size) {
        UpdateContext<EntryNode<E>> updateContext = this.updateContext(size, null);
        try {
            AbstractTrieSet abstractTrieSet = (AbstractTrieSet)this.doAddAll(updateContext, Iterators.transform(elements.iterator(), (Function)ELEMENT_TO_ENTRY));
            return (This)abstractTrieSet;
        }
        finally {
            this.commit(updateContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public This disj(Object element) {
        UpdateContext<EntryNode<E>> updateContext = this.updateContext(1, null);
        try {
            AbstractTrieSet abstractTrieSet = (AbstractTrieSet)this.doRemove(updateContext, element);
            return (This)abstractTrieSet;
        }
        finally {
            this.commit(updateContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public This disjAll(Iterable<? extends E> elements) {
        UpdateContext<EntryNode<E>> updateContext = this.updateContext(1, null);
        try {
            AbstractTrieSet abstractTrieSet = (AbstractTrieSet)this.doRemoveAll(updateContext, elements.iterator());
            return (This)abstractTrieSet;
        }
        finally {
            this.commit(updateContext);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.doIterator(), (Function)ENTRY_TO_ELEMENT);
    }

    protected UpdateContext<EntryNode<E>> updateContext(int expectedSize, Merger<EntryNode<E>> merger) {
        return new UpdateContext<EntryNode<E>>(expectedSize, merger);
    }

    public boolean contains(Object o) {
        return this.containsKey(o);
    }

    static class ElementSpliterator<E>
    extends AbstractHashTrie.NodeSpliterator<E, E, EntryNode<E>> {
        public ElementSpliterator(AbstractHashTrie.Node<E, EntryNode<E>> node, int sizeEstimate, boolean immutable) {
            super(node, sizeEstimate, 1 | (immutable ? 1024 : 0));
        }

        public ElementSpliterator(AbstractHashTrie.Node<E, EntryNode<E>>[] array, int pos, int limit, int sizeEstimate, boolean immutable) {
            super(array, pos, limit, sizeEstimate, 1 | (immutable ? 1024 : 0));
        }

        @Override
        protected AbstractHashTrie.NodeSpliterator<E, E, EntryNode<E>> newSubSpliterator(AbstractHashTrie.Node<E, EntryNode<E>>[] array, int pos, int limit, int sizeEstimate) {
            return new ElementSpliterator<E>(array, pos, limit, sizeEstimate, this.hasCharacteristics(1024));
        }

        @Override
        protected E apply(EntryNode<E> entry) {
            return (E)entry.key;
        }
    }

    public static final class EntryNode<E>
    extends AbstractHashTrie.EntryNode<E, EntryNode<E>> {
        public EntryNode(E element) {
            super(element);
        }

        public E element() {
            return (E)this.key;
        }

        @Override
        public AbstractHashTrie.Node<E, EntryNode<E>> assocInternal(UpdateContext<? super EntryNode<E>> currentContext, int shift, int hash, EntryNode<E> newEntry) {
            if (Objects.equal((Object)this.key, (Object)newEntry.key)) {
                currentContext.merge(this, newEntry);
                return this;
            }
            return this.split(currentContext, shift, hash, newEntry);
        }
    }
}

