/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.javersion.util.AbstractRedBlackTree;
import org.javersion.util.MapUtils;
import org.javersion.util.Merger;
import org.javersion.util.UpdateContext;

public abstract class AbstractTreeMap<K, V, This extends AbstractTreeMap<K, V, This>>
extends AbstractRedBlackTree<K, Node<K, V>, This>
implements Iterable<Map.Entry<K, V>> {
    protected AbstractTreeMap() {
    }

    protected AbstractTreeMap(Comparator<? super K> comparator) {
        super(comparator);
    }

    @Override
    public abstract int size();

    protected abstract Node<K, V> root();

    protected UpdateContext<Map.Entry<K, V>> updateContext() {
        return this.updateContext(null);
    }

    protected UpdateContext<Map.Entry<K, V>> updateContext(Merger<Map.Entry<K, V>> merger) {
        return new UpdateContext<Map.Entry<K, V>>(1, merger);
    }

    public V get(Object key) {
        Node<K, V> node = this.find(this.root(), key);
        return node != null ? (V)node.value : null;
    }

    public V max() {
        Node<K, V> max = this.findMax(this.root());
        return max != null ? (V)max.value : null;
    }

    public V min() {
        Node<K, V> min = this.findMin(this.root());
        return min != null ? (V)min.value : null;
    }

    public This assoc(K key, V value) {
        UpdateContext<Map.Entry<K, V>> context = this.updateContext();
        return (This)((AbstractTreeMap)this.doAdd(context, this.root(), new Node<K, V>(context, key, value, AbstractRedBlackTree.Color.RED)));
    }

    public This assocAll(Map<? extends K, ? extends V> map) {
        UpdateContext<Map.Entry<K, V>> context = this.updateContext();
        return (This)((AbstractTreeMap)this.doAddAll(context, this.root(), Iterables.transform(map.entrySet(), entry -> this.entryToNode((Map.Entry<? extends K, ? extends V>)entry, context))));
    }

    private Node entryToNode(Map.Entry<? extends K, ? extends V> entry, UpdateContext<Map.Entry<K, V>> context) {
        if (entry instanceof Node) {
            return (Node)entry;
        }
        return new Node<K, V>(context, entry.getKey(), entry.getValue(), AbstractRedBlackTree.Color.RED);
    }

    public This dissoc(Object keyObj) {
        return (This)((AbstractTreeMap)this.doRemove(this.updateContext(), this.root(), keyObj));
    }

    public This assocAll(Iterable<Map.Entry<K, V>> entries) {
        UpdateContext<Map.Entry<K, V>> context = this.updateContext();
        return (This)((AbstractTreeMap)this.doAddAll(context, this.root(), Iterables.transform(entries, entry -> this.entryToNode((Map.Entry<? extends K, ? extends V>)entry, context))));
    }

    public This merge(K key, V value, Merger<Map.Entry<K, V>> merger) {
        UpdateContext<Map.Entry<K, V>> context = this.updateContext(merger);
        return (This)((AbstractTreeMap)this.doAdd(context, this.root(), new Node<K, V>(context, key, value, AbstractRedBlackTree.Color.RED)));
    }

    public This mergeAll(Map<? extends K, ? extends V> map, Merger<Map.Entry<K, V>> merger) {
        UpdateContext<Map.Entry<K, V>> context = this.updateContext(merger);
        return (This)((AbstractTreeMap)this.doAddAll(context, this.root(), Iterables.transform(map.entrySet(), entry -> this.entryToNode((Map.Entry<? extends K, ? extends V>)entry, context))));
    }

    public This mergeAll(Iterable<Map.Entry<K, V>> entries, Merger<Map.Entry<K, V>> merger) {
        UpdateContext<Map.Entry<K, V>> context = this.updateContext(merger);
        return (This)((AbstractTreeMap)this.doAddAll(context, this.root(), Iterables.transform(entries, entry -> this.entryToNode((Map.Entry<? extends K, ? extends V>)entry, context))));
    }

    public This dissoc(Object key, Merger<Map.Entry<K, V>> merger) {
        UpdateContext<Map.Entry<K, V>> context = this.updateContext(merger);
        return (This)((AbstractTreeMap)this.doRemove(context, this.root(), key));
    }

    public boolean containsKey(Object key) {
        return this.find(this.root(), key) != null;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.iterator(true);
    }

    public Iterator<Map.Entry<K, V>> iterator(boolean asc) {
        return Iterators.transform(this.doIterator(this.root(), true), Map.Entry.class::cast);
    }

    public Iterable<Map.Entry<K, V>> range(K from, K to) {
        return this.range(from, true, to, false, true);
    }

    public Iterable<Map.Entry<K, V>> range(K from, K to, boolean asc) {
        return this.range(from, true, to, false, asc);
    }

    public Iterable<Map.Entry<K, V>> range(K from, boolean fromInclusive, K to, boolean toInclusive) {
        return this.range(from, fromInclusive, to, toInclusive, true);
    }

    public Iterable<Map.Entry<K, V>> range(final K from, final boolean fromInclusive, final K to, final boolean toInclusive, final boolean asc) {
        return new Iterable<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return Iterators.transform(AbstractTreeMap.this.doRangeIterator(AbstractTreeMap.this.root(), asc, from, fromInclusive, to, toInclusive), Map.Entry.class::cast);
            }
        };
    }

    public Iterable<K> keys() {
        return Iterables.transform((Iterable)this, MapUtils.mapKeyFunction());
    }

    public Iterable<V> values() {
        return Iterables.transform((Iterable)this, MapUtils.mapValueFunction());
    }

    static class ValueSpliterator<K, V>
    extends AbstractRedBlackTree.RBSpliterator<V, Node<K, V>> {
        private final Comparator<? super K> comparator;

        public ValueSpliterator(Node<K, V> root, int size, Comparator<? super K> comparator, boolean immutable) {
            super(root, size, immutable ? 1024 : 0);
            this.comparator = comparator;
        }

        protected ValueSpliterator(int sizeEstimate, Comparator<? super K> comparator, boolean immutable) {
            super(sizeEstimate, immutable ? 1024 : 0);
            this.comparator = comparator;
        }

        @Override
        protected AbstractRedBlackTree.RBSpliterator<V, Node<K, V>> newSpliterator(int sizeEstimate) {
            return new ValueSpliterator<K, V>(sizeEstimate, this.comparator, this.hasCharacteristics(1024));
        }

        @Override
        protected V apply(Node<K, V> node) {
            return node.value;
        }
    }

    static class KeySpliterator<K, V>
    extends AbstractRedBlackTree.RBSpliterator<K, Node<K, V>> {
        private final Comparator<? super K> comparator;

        public KeySpliterator(Node<K, V> root, int size, Comparator<? super K> comparator, boolean immutable) {
            super(root, size, 5 | (immutable ? 1024 : 0));
            this.comparator = comparator;
        }

        protected KeySpliterator(int sizeEstimate, Comparator<? super K> comparator, boolean immutable) {
            super(sizeEstimate, 5 | (immutable ? 1024 : 0));
            this.comparator = comparator;
        }

        @Override
        protected AbstractRedBlackTree.RBSpliterator<K, Node<K, V>> newSpliterator(int sizeEstimate) {
            return new KeySpliterator<K, V>(sizeEstimate, this.comparator, this.hasCharacteristics(1024));
        }

        @Override
        protected K apply(Node<K, V> node) {
            return (K)node.key;
        }

        @Override
        public Comparator<? super K> getComparator() {
            return this.comparator;
        }
    }

    static class EntrySpliterator<K, V>
    extends AbstractRedBlackTree.RBSpliterator<Map.Entry<K, V>, Node<K, V>> {
        private final Comparator<? super K> comparator;

        public EntrySpliterator(Node<K, V> root, int size, Comparator<? super K> comparator, boolean immutable) {
            super(root, size, 5 | (immutable ? 1024 : 0));
            this.comparator = comparator;
        }

        protected EntrySpliterator(int sizeEstimate, Comparator<? super K> comparator, boolean immutable) {
            super(sizeEstimate, 5 | (immutable ? 1024 : 0));
            this.comparator = comparator;
        }

        @Override
        protected AbstractRedBlackTree.RBSpliterator<Map.Entry<K, V>, Node<K, V>> newSpliterator(int sizeEstimate) {
            return new EntrySpliterator<K, V>(sizeEstimate, this.comparator, this.hasCharacteristics(1024));
        }

        @Override
        protected Map.Entry<K, V> apply(Node<K, V> node) {
            return node;
        }

        @Override
        public Comparator<? super Map.Entry<K, V>> getComparator() {
            return Map.Entry.comparingByKey(this.comparator);
        }
    }

    static class Node<K, V>
    extends AbstractRedBlackTree.Node<K, Node<K, V>>
    implements Map.Entry<K, V> {
        V value;

        public Node(UpdateContext<? super Node<K, V>> context, K key, V value, AbstractRedBlackTree.Color color) {
            this(context, key, value, color, null, null);
        }

        public Node(UpdateContext<? super Node<K, V>> context, K key, V value, AbstractRedBlackTree.Color color, Node<K, V> left, Node<K, V> right) {
            super(context, key, color, left, right);
            this.value = value;
        }

        @Override
        public K getKey() {
            return (K)this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public Node<K, V> self() {
            return this;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Node<K, V> cloneWith(UpdateContext<? super Node<K, V>> currentContext) {
            return new Node<Object, V>(currentContext, this.key, this.value, this.color, (Node)this.left, (Node)this.right);
        }

        @Override
        protected Node<K, V> replaceWith(UpdateContext<? super Node<K, V>> currentContext, Node<K, V> node) {
            if (node == this || Objects.equal(this.value, node.value)) {
                return null;
            }
            if (this.context.isSameAs(currentContext)) {
                this.value = node.value;
                return this;
            }
            if (node.context.isSameAs(currentContext)) {
                node.color = this.color;
                node.left = this.left;
                node.right = this.right;
                return node;
            }
            throw new IllegalStateException("node from another UpdateContext");
        }

        public String toString() {
            return this.getKey() + ": " + this.getValue();
        }
    }
}

