/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.javersion.util.UpdateContext;

public abstract class AbstractRedBlackTree<K, N extends Node<K, N>, This extends AbstractRedBlackTree<K, N, This>> {
    private static final Comparator<Comparable> NATURAL = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable left, Comparable right) {
            return left.compareTo(right);
        }
    };
    protected final Comparator<? super K> comparator;

    public AbstractRedBlackTree() {
        this(NATURAL);
    }

    public AbstractRedBlackTree(Comparator<? super K> comparator) {
        this.comparator = Objects.requireNonNull(comparator, "comparator");
    }

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected abstract This doReturn(Comparator<? super K> var1, N var2, int var3);

    private This commitAndReturn(UpdateContext<? super N> context, Comparator<? super K> comparator, N newRoot, int newSize) {
        this.commit(context);
        return this.doReturn(comparator, newRoot, newSize);
    }

    protected void commit(UpdateContext<?> context) {
        context.commit();
    }

    protected final N find(N root, Object keyObj) {
        Object key = keyObj;
        Object node = root;
        while (node != null) {
            int cmp = this.comparator.compare(key, ((Node)node).key);
            if (cmp < 0) {
                node = ((Node)node).left;
                continue;
            }
            if (cmp > 0) {
                node = ((Node)node).right;
                continue;
            }
            return node;
        }
        return null;
    }

    protected final N findMin(N node) {
        while (node != null) {
            if (((Node)node).left == null) {
                return node;
            }
            node = ((Node)node).left;
        }
        return null;
    }

    protected final N findMax(N node) {
        while (node != null) {
            if (((Node)node).right == null) {
                return node;
            }
            node = ((Node)node).right;
        }
        return null;
    }

    protected final N floorNode(N node, K key) {
        Object current = node;
        N floor = null;
        while (current != null) {
            int cmp = this.comparator.compare(((Node)current).key, key);
            if (cmp < 0) {
                floor = current;
                current = ((Node)current).right;
                continue;
            }
            if (cmp > 0) {
                current = ((Node)current).left;
                continue;
            }
            return current;
        }
        return floor;
    }

    protected final N lowerNode(N node, K key) {
        Object current = node;
        N lower = null;
        while (current != null) {
            int cmp = this.comparator.compare(((Node)current).key, key);
            if (cmp < 0) {
                lower = current;
                current = ((Node)current).right;
                continue;
            }
            current = ((Node)current).left;
        }
        return lower;
    }

    protected final N ceilingNode(N node, K key) {
        Object current = node;
        N ceiling = null;
        while (current != null) {
            int cmp = this.comparator.compare(((Node)current).key, key);
            if (cmp > 0) {
                ceiling = current;
                current = ((Node)current).left;
                continue;
            }
            if (cmp < 0) {
                current = ((Node)current).right;
                continue;
            }
            return current;
        }
        return ceiling;
    }

    protected final N higherNode(N node, K key) {
        Object current = node;
        N ceiling = null;
        while (current != null) {
            int cmp = this.comparator.compare(((Node)current).key, key);
            if (cmp > 0) {
                ceiling = current;
                current = ((Node)current).left;
                continue;
            }
            current = ((Node)current).right;
        }
        return ceiling;
    }

    protected final This doAdd(UpdateContext<? super N> context, N root, N node) {
        if (root == null) {
            context.insert(node);
            return this.commitAndReturn(context, this.comparator, ((Node)node).edit(context, Color.BLACK, null, null), 1);
        }
        Node newRoot = ((Node)root).add(context, ((Node)node).edit(context, Color.RED, null, null), this.comparator);
        if (newRoot == null) {
            return this.self();
        }
        return this.commitAndReturn(context, this.comparator, newRoot.blacken(context), this.size() + context.getChangeAndReset());
    }

    protected final This doAddAll(UpdateContext<? super N> context, N root, Iterable<N> nodes) {
        N newRoot = root;
        Node rootCandidate = null;
        int newSize = this.size();
        for (Node node : nodes) {
            if (newRoot == null) {
                ++newSize;
                rootCandidate = node.edit(context, Color.BLACK, null, null);
            } else {
                rootCandidate = ((Node)newRoot).add(context, node.edit(context, Color.RED, null, null), this.comparator);
            }
            if (rootCandidate == null) continue;
            newRoot = rootCandidate.blacken(context);
            newSize += context.getChangeAndReset();
        }
        return this.commitAndReturn(context, this.comparator, newRoot, newSize);
    }

    protected Iterator<N> doIterator(N root, boolean asc) {
        return new RBIterator(root, asc);
    }

    protected Iterator<N> doRangeIterator(N root, boolean asc, K from, boolean fromInclusive, K to, boolean toInclusive) {
        return new RangeIterator<K, N>(root, asc, this.comparator, from, fromInclusive, to, toInclusive);
    }

    protected final This doRemove(UpdateContext<? super N> context, N root, Object keyObj) {
        Object key = keyObj;
        if (root == null) {
            return this.self();
        }
        N newRoot = ((Node)root).remove(context, key, this.comparator);
        if (!context.hasChanged()) {
            return this.self();
        }
        if (newRoot != null) {
            return this.commitAndReturn(context, this.comparator, ((Node)newRoot).blacken(context), this.size() + context.getChangeAndReset());
        }
        return this.commitAndReturn(context, this.comparator, null, 0);
    }

    protected This self() {
        return (This)this;
    }

    private static boolean isBlack(Node<?, ?> node) {
        return node != null && node.color == Color.BLACK;
    }

    private static boolean isRed(Node<?, ?> node) {
        return node != null && node.color == Color.RED;
    }

    private static <K, N extends Node<K, N>> N balanceLeftDel(UpdateContext<? super N> currentContext, N node, N left, N right) {
        if (AbstractRedBlackTree.isRed(left)) {
            return node.edit(currentContext, Color.RED, left.blacken(currentContext), right);
        }
        if (AbstractRedBlackTree.isBlack(right)) {
            return AbstractRedBlackTree.balanceRight(currentContext, node, left, right.redden(currentContext));
        }
        if (AbstractRedBlackTree.isRed(right) && AbstractRedBlackTree.isBlack(right.left)) {
            ? super N rightLeft = right.left;
            N newLeft = node.edit(currentContext, Color.BLACK, left, rightLeft.left);
            N newRight = AbstractRedBlackTree.balanceRight(currentContext, right, rightLeft.right, right.right.redden(currentContext));
            return rightLeft.edit(currentContext, Color.RED, newLeft, newRight);
        }
        throw new IllegalStateException("Illegal invariant");
    }

    private static <K, N extends Node<K, N>> N balanceRightDel(UpdateContext<? super N> currentContext, N node, N left, N right) {
        if (AbstractRedBlackTree.isRed(right)) {
            return node.edit(currentContext, Color.RED, left, right.blacken(currentContext));
        }
        if (AbstractRedBlackTree.isBlack(left)) {
            return AbstractRedBlackTree.balanceLeft(currentContext, node, left.redden(currentContext), right);
        }
        if (AbstractRedBlackTree.isRed(left) && AbstractRedBlackTree.isBlack(left.right)) {
            ? super N leftRight = left.right;
            N newLeft = AbstractRedBlackTree.balanceLeft(currentContext, left, left.left.redden(currentContext), leftRight.left);
            N newRight = node.edit(currentContext, Color.BLACK, leftRight.right, right);
            return leftRight.edit(currentContext, Color.RED, newLeft, newRight);
        }
        throw new IllegalStateException("Illegal invariant");
    }

    private static <K, N extends Node<K, N>> N balanceLeft(UpdateContext<? super N> currentContext, N node, N left, N right) {
        if (AbstractRedBlackTree.isRed(left) && AbstractRedBlackTree.isRed(left.left)) {
            N newRight = node.edit(currentContext, Color.BLACK, left.right, right);
            return left.edit(currentContext, Color.RED, left.left.blacken(currentContext), newRight);
        }
        if (AbstractRedBlackTree.isRed(left) && AbstractRedBlackTree.isRed(left.right)) {
            ? super N leftRight = left.right;
            N newLeft = left.edit(currentContext, Color.BLACK, left.left, leftRight.left);
            N newRight = node.edit(currentContext, Color.BLACK, leftRight.right, right);
            return leftRight.edit(currentContext, Color.RED, newLeft, newRight);
        }
        return node.edit(currentContext, Color.BLACK, left, right);
    }

    private static <K, N extends Node<K, N>> N balanceRight(UpdateContext<? super N> currentContext, N node, N left, N right) {
        if (AbstractRedBlackTree.isRed(right) && AbstractRedBlackTree.isRed(right.right)) {
            N newLeft = node.edit(currentContext, Color.BLACK, left, right.left);
            return right.edit(currentContext, Color.RED, newLeft, right.right.blacken(currentContext));
        }
        if (AbstractRedBlackTree.isRed(right) && AbstractRedBlackTree.isRed(right.left)) {
            ? super N rightLeft = right.left;
            N newLeft = node.edit(currentContext, Color.BLACK, left, rightLeft.left);
            N newRight = right.edit(currentContext, Color.BLACK, rightLeft.right, right.right);
            return rightLeft.edit(currentContext, Color.RED, newLeft, newRight);
        }
        return node.edit(currentContext, Color.BLACK, left, right);
    }

    static abstract class RBSpliterator<T, N extends Node<?, N>>
    implements Spliterator<T> {
        private N root;
        private int sizeEstimate;
        private Deque<N> stack;
        private final int characteristics;

        protected RBSpliterator(N root, int size, int additionalCharacteristics) {
            this.root = (Node)Objects.requireNonNull(root, "root");
            this.stack = new ArrayDeque<N>();
            this.sizeEstimate = size;
            this.characteristics = RBSpliterator.ordered(RBSpliterator.sized(additionalCharacteristics));
        }

        protected RBSpliterator(int sizeEstimate, int additionalCharacteristics) {
            this.sizeEstimate = sizeEstimate;
            this.characteristics = RBSpliterator.ordered(RBSpliterator.nonSized(additionalCharacteristics));
        }

        private static int sized(int characteristics) {
            return characteristics | 0x40;
        }

        private static int ordered(int characteristics) {
            return characteristics | 0x10;
        }

        private static int nonSized(int characteristics) {
            return characteristics & 0xFFFFFFBF;
        }

        private void init() {
            if (this.root != null) {
                this.pushAll(this.root);
                this.root = null;
            }
        }

        protected void pushAll(N node) {
            while (node != null) {
                this.stack.addFirst(node);
                node = ((Node)node).left;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            this.init();
            if (this.stack.isEmpty()) {
                return false;
            }
            Node result = (Node)this.stack.removeFirst();
            action.accept(this.apply(result));
            this.pushAll(result.right);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (this.root != null) {
                this.forEach(this.root, action);
                this.root = null;
            } else {
                while (!this.stack.isEmpty()) {
                    Node next = (Node)this.stack.removeFirst();
                    action.accept(this.apply(next));
                    if (next.right == null) continue;
                    this.forEach(next.right, action);
                }
            }
        }

        private void forEach(N node, Consumer<? super T> action) {
            if (((Node)node).left != null) {
                this.forEach(((Node)node).left, action);
            }
            action.accept(this.apply(node));
            if (((Node)node).right != null) {
                this.forEach(((Node)node).right, action);
            }
        }

        @Override
        public Spliterator<T> trySplit() {
            if (this.root != null) {
                return this.splitRoot();
            }
            return this.splitStack();
        }

        private Spliterator<T> splitRoot() {
            if (((Node)this.root).left == null || ((Node)this.root).right == null) {
                return null;
            }
            RBSpliterator<T, N> prefix = this.split();
            prefix.stack = new ArrayDeque<N>();
            prefix.root = ((Node)this.root).left;
            this.stack.push(this.root);
            this.root = null;
            return prefix;
        }

        private Spliterator<T> splitStack() {
            if (this.stack.size() < 2) {
                return null;
            }
            Node mid = (Node)this.stack.removeLast();
            RBSpliterator<T, N> prefix = this.split();
            prefix.stack = this.stack;
            this.stack = new ArrayDeque<N>();
            this.stack.push(mid);
            return prefix;
        }

        private RBSpliterator<T, N> split() {
            return this.newSpliterator(this.sizeEstimate >>>= 1);
        }

        protected abstract RBSpliterator<T, N> newSpliterator(int var1);

        protected abstract T apply(N var1);

        @Override
        public long estimateSize() {
            return this.sizeEstimate;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }
    }

    static class RangeIterator<K, N extends Node<K, N>>
    extends AbstractRBIterator<K, N> {
        final Comparator<? super K> comparator;
        final K from;
        final boolean fromInclusive;
        final K to;
        final boolean toInclusive;

        public RangeIterator(N root, boolean asc, Comparator<? super K> comparator, K from, boolean fromInclusive, K to, boolean toInclusive) {
            super(asc);
            this.comparator = comparator;
            this.from = from;
            this.fromInclusive = fromInclusive;
            this.to = to;
            this.toInclusive = toInclusive;
            this.pushAll(root);
        }

        @Override
        protected void pushAll(N node) {
            while (node != null) {
                boolean fromIncluded = this.fromIncluded(((Node)node).key);
                boolean toIncluded = this.toIncluded(((Node)node).key);
                if (fromIncluded && toIncluded) {
                    this.stack.push(node);
                }
                if (this.asc) {
                    node = fromIncluded ? ((Node)node).left : ((Node)node).right;
                    continue;
                }
                node = toIncluded ? ((Node)node).right : ((Node)node).left;
            }
        }

        private boolean fromIncluded(K key) {
            return this.from == null || this.isIncluded(this.from, key, this.fromInclusive);
        }

        private boolean toIncluded(K key) {
            return this.to == null || this.isIncluded(key, this.to, this.toInclusive);
        }

        private boolean isIncluded(K key1, K key2, boolean inclusive) {
            int cmpr = this.comparator.compare(key1, key2);
            return cmpr < 0 || inclusive && cmpr == 0;
        }
    }

    static class RBIterator<K, N extends Node<K, N>>
    extends AbstractRBIterator<K, N> {
        public RBIterator(N root, boolean asc) {
            super(asc);
            this.pushAll(root);
        }

        @Override
        protected void pushAll(N node) {
            while (node != null) {
                this.stack.push(node);
                node = this.asc ? ((Node)node).left : ((Node)node).right;
            }
        }
    }

    static abstract class AbstractRBIterator<K, N extends Node<K, N>>
    extends UnmodifiableIterator<N> {
        final Deque<N> stack = new ArrayDeque<N>();
        final boolean asc;

        public AbstractRBIterator(boolean asc) {
            this.asc = asc;
        }

        protected abstract void pushAll(N var1);

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public N next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node result = (Node)this.stack.pop();
            this.pushAll(this.asc ? result.right : result.left);
            return (N)result;
        }
    }

    static enum Mirror {
        RIGHT{

            @Override
            <K, N extends Node<K, N>> N leftOf(N node) {
                return (N)node.right;
            }

            @Override
            <K, N extends Node<K, N>> N rightOf(N node) {
                return (N)node.left;
            }

            @Override
            <K, N extends Node<K, N>> void setLeftOf(N node, N left) {
                node.right = left;
            }

            @Override
            <K, N extends Node<K, N>> void setRightOf(N node, N right) {
                node.left = right;
            }

            @Override
            <K, N extends Node<K, N>> N balanceDelete(UpdateContext<? super N> currentContext, N node, N newChild) {
                return (N)AbstractRedBlackTree.balanceRightDel(currentContext, node, node.left, newChild);
            }

            @Override
            <K, N extends Node<K, N>> N delete(UpdateContext<? super N> currentContext, N node, N newChild) {
                return node.edit(currentContext, Color.RED, node.left, newChild);
            }
        }
        ,
        LEFT;


        <K, N extends Node<K, N>> N leftOf(N node) {
            return (N)node.left;
        }

        <K, N extends Node<K, N>> N rightOf(N node) {
            return (N)node.right;
        }

        <K, N extends Node<K, N>> void setLeftOf(N node, N left) {
            node.left = left;
        }

        <K, N extends Node<K, N>> void setRightOf(N node, N right) {
            node.right = right;
        }

        <K, N extends Node<K, N>> void children(N node, N left, N right) {
            this.setLeftOf(node, left);
            this.setRightOf(node, right);
        }

        <K, N extends Node<K, N>> N add(UpdateContext<? super N> currentContext, N self, N node, Comparator<? super K> comparator) {
            N newChild;
            N left = this.leftOf(self);
            if (left == null) {
                currentContext.insert(node);
                newChild = node;
            } else {
                newChild = left.add(currentContext, node, comparator);
            }
            if (newChild == null) {
                return null;
            }
            return self.color.add(currentContext, self, newChild, this);
        }

        <K, N extends Node<K, N>> N balanceDelete(UpdateContext<? super N> currentContext, N node, N newChild) {
            return (N)AbstractRedBlackTree.balanceLeftDel(currentContext, node, newChild, node.right);
        }

        <K, N extends Node<K, N>> N delete(UpdateContext<? super N> currentContext, N node, N newChild) {
            return node.edit(currentContext, Color.RED, newChild, node.right);
        }

        <K, N extends Node<K, N>> N remove(UpdateContext<? super N> currentContext, N self, K key, Comparator<? super K> comparator) {
            N child = this.leftOf(self);
            if (child == null) {
                return self;
            }
            boolean balance = AbstractRedBlackTree.isBlack(this.leftOf(self));
            N newChild = child.remove(currentContext, key, comparator);
            if (!currentContext.hasChanged()) {
                return self;
            }
            if (balance) {
                return this.balanceDelete((UpdateContext<? super N>)currentContext, self, newChild);
            }
            return this.delete((UpdateContext<? super N>)currentContext, self, newChild);
        }
    }

    static enum Color {
        RED{

            @Override
            <K, N extends Node<K, N>> N balanceInsert(UpdateContext<? super N> currentContext, N parent, N child, Mirror mirror) {
                N result;
                N left = mirror.leftOf(child);
                N right = mirror.rightOf(child);
                if (AbstractRedBlackTree.isRed(left)) {
                    N newRight = parent.toEditable(currentContext);
                    ((Node)newRight).color = BLACK;
                    mirror.children(newRight, right, mirror.rightOf(parent));
                    result = child.toEditable(currentContext);
                    ((Node)result).color = RED;
                    mirror.children(result, left.blacken(currentContext), newRight);
                } else if (AbstractRedBlackTree.isRed(right)) {
                    N newLeft = child.toEditable(currentContext);
                    ((Node)newLeft).color = BLACK;
                    mirror.children(newLeft, left, mirror.leftOf(right));
                    N newRight = parent.toEditable(currentContext);
                    ((Node)newRight).color = BLACK;
                    mirror.children(newRight, mirror.rightOf(right), mirror.rightOf(parent));
                    result = right.toEditable(currentContext);
                    ((Node)result).color = RED;
                    mirror.children(result, newLeft, newRight);
                } else {
                    result = BLACK.balanceInsert(currentContext, parent, child, mirror);
                }
                return result;
            }

            @Override
            <K, N extends Node<K, N>> N add(UpdateContext<? super N> currentContext, N node, N newChild, Mirror mirror) {
                N editable = node.toEditable(currentContext);
                mirror.setLeftOf(editable, newChild);
                ((Node)editable).color = RED;
                return editable;
            }
        }
        ,
        BLACK;


        <K, N extends Node<K, N>> N balanceInsert(UpdateContext<? super N> currentContext, N parent, N child, Mirror mirror) {
            N result = parent.toEditable(currentContext);
            ((Node)result).color = BLACK;
            mirror.children(result, child, mirror.rightOf(parent));
            return result;
        }

        <K, N extends Node<K, N>> N add(UpdateContext<? super N> currentContext, N node, N newChild, Mirror mirror) {
            N editable = node.toEditable(currentContext);
            mirror.setLeftOf(editable, newChild);
            return newChild.color.balanceInsert(currentContext, editable, newChild, mirror);
        }
    }

    static abstract class Node<K, This extends Node<K, This>>
    implements Cloneable {
        final UpdateContext<? super This> context;
        final K key;
        Color color;
        This left;
        This right;

        protected Node(UpdateContext<? super This> context, K key, Color color, This left, This right) {
            this.context = context;
            this.key = key;
            this.color = color;
            this.left = left;
            this.right = right;
        }

        protected This self() {
            return (This)this;
        }

        This blacken(UpdateContext<? super This> currentContext) {
            return this.changeColor(currentContext, Color.BLACK);
        }

        This redden(UpdateContext<? super This> currentContext) {
            return this.changeColor(currentContext, Color.RED);
        }

        protected This add(UpdateContext<? super This> currentContext, This node, Comparator<? super K> comparator) {
            This self = this.self();
            int cmpr = comparator.compare(((Node)node).key, this.key);
            if (cmpr == 0) {
                if (currentContext.merge(self, node)) {
                    return this.replaceWith(currentContext, node);
                }
                return null;
            }
            if (cmpr < 0) {
                return Mirror.LEFT.add(currentContext, self, node, comparator);
            }
            return Mirror.RIGHT.add(currentContext, self, node, comparator);
        }

        protected This remove(UpdateContext<? super This> currentContext, K key, Comparator<? super K> comparator) {
            This self = this.self();
            int cmpr = comparator.compare(key, ((Node)self).key);
            if (cmpr == 0) {
                currentContext.delete(this.self());
                return this.append(currentContext, this.left, this.right);
            }
            if (cmpr < 0) {
                return Mirror.LEFT.remove(currentContext, self, key, comparator);
            }
            return Mirror.RIGHT.remove(currentContext, self, key, comparator);
        }

        private This append(UpdateContext<? super This> currentContext, This left, This right) {
            if (left == null) {
                return (This)right;
            }
            if (right == null) {
                return (This)left;
            }
            if (AbstractRedBlackTree.isRed(left)) {
                if (AbstractRedBlackTree.isRed(right)) {
                    ? super This app = this.append(currentContext, left.right, right.left);
                    if (AbstractRedBlackTree.isRed(app)) {
                        This newLeft = left.edit(currentContext, Color.RED, left.left, app.left);
                        This newRight = right.edit(currentContext, Color.RED, app.right, right.right);
                        return app.edit(currentContext, Color.RED, newLeft, newRight);
                    }
                    This newRight = right.edit(currentContext, Color.RED, app, right.right);
                    return left.edit(currentContext, Color.RED, left.left, newRight);
                }
                This newRight = this.append(currentContext, left.right, right);
                return left.edit(currentContext, Color.RED, left.left, newRight);
            }
            if (AbstractRedBlackTree.isRed(right)) {
                This newLeft = this.append(currentContext, left, right.left);
                return right.edit(currentContext, Color.RED, newLeft, right.right);
            }
            ? super This app = this.append(currentContext, left.right, right.left);
            if (AbstractRedBlackTree.isRed(app)) {
                This newLeft = left.edit(currentContext, Color.BLACK, left.left, app.left);
                This newRight = right.edit(currentContext, Color.BLACK, app.right, right.right);
                return app.edit(currentContext, Color.RED, newLeft, newRight);
            }
            This newRight = right.edit(currentContext, Color.BLACK, app, right.right);
            return (This)AbstractRedBlackTree.balanceLeftDel(currentContext, left, left.left, newRight);
        }

        This changeColor(UpdateContext<? super This> currentContext, Color newColor) {
            This node = this.toEditable(currentContext);
            ((Node)node).color = newColor;
            return node;
        }

        This edit(UpdateContext<? super This> currentContext, Color newColor, This newLeft, This newRight) {
            This node = this.toEditable(currentContext);
            ((Node)node).color = newColor;
            ((Node)node).left = newLeft;
            ((Node)node).right = newRight;
            return node;
        }

        This toEditable(UpdateContext<? super This> currentContext) {
            if (this.context.isSameAs(currentContext)) {
                return this.self();
            }
            return this.cloneWith(currentContext);
        }

        abstract This cloneWith(UpdateContext<? super This> var1);

        abstract This replaceWith(UpdateContext<? super This> var1, This var2);
    }
}

