/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.javersion.util.UpdateContext;

public abstract class AbstractHashTrie<K, E extends EntryNode<K, E>, This extends AbstractHashTrie<K, E, This>> {
    private static final Iterator<EntryNode> EMTPY_ITER = Collections.emptyIterator();
    static final Node EMPTY_NODE = new Node(){

        @Override
        public Iterator<EntryNode> iterator() {
            return EMTPY_ITER;
        }

        EntryNode findInternal(int shift, int hash, Object key) {
            return null;
        }

        Node dissocInternal(UpdateContext currentContext, int shift, int hash, Object key) {
            return this;
        }

        Node assocInternal(UpdateContext currentContext, int shift, int hash, EntryNode newEntryNode) {
            currentContext.insert(newEntryNode);
            if (currentContext.expectedUpdates() == 1) {
                return newEntryNode;
            }
            HashNode node = new HashNode(currentContext);
            return ((Node)node).assocInternal(currentContext, shift, hash, newEntryNode);
        }

        protected Node[] getChildren() {
            return null;
        }
    };

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected This self() {
        return (This)this;
    }

    protected abstract This doReturn(Node<K, E> var1, int var2);

    protected abstract Node<K, E> root();

    public boolean containsKey(Object key) {
        return this.root().find(key) != null;
    }

    protected final Iterator<E> doIterator() {
        return this.root().iterator();
    }

    private This commitAndReturn(UpdateContext<? super E> updateContext, Node<K, E> newRoot, int newSize) {
        this.commit(updateContext);
        return this.doReturn(newRoot, newSize);
    }

    protected final This doAdd(UpdateContext<? super E> updateContext, E newEntry) {
        Node<K, ? super E> newRoot = this.root().assoc((UpdateContext<? super E>)updateContext, (E)newEntry);
        return this.commitAndReturn(updateContext, newRoot, this.size() + updateContext.getChangeAndReset());
    }

    protected final This doAddAll(UpdateContext<? super E> updateContext, Iterator entries) {
        Node<K, EntryNode> newRoot = this.root();
        int size = this.size();
        while (entries.hasNext()) {
            EntryNode entry = (EntryNode)entries.next();
            newRoot = newRoot.assoc(updateContext, entry);
            size += updateContext.getChangeAndReset();
        }
        return this.commitAndReturn(updateContext, newRoot, size);
    }

    protected final This doRemove(UpdateContext<? super E> updateContext, Object key) {
        Node<K, ? super E> newRoot = this.root().dissoc(updateContext, key);
        return this.commitAndReturn(updateContext, newRoot, this.size() + updateContext.getChangeAndReset());
    }

    protected final This doRemoveAll(UpdateContext<? super E> updateContext, Iterator keys) {
        Node<K, ? super E> newRoot = this.root();
        int size = this.size();
        while (keys.hasNext()) {
            newRoot = newRoot.dissoc(updateContext, keys.next());
            size += updateContext.getChangeAndReset();
        }
        return this.commitAndReturn(updateContext, newRoot, size);
    }

    protected void commit(UpdateContext<?> updateContext) {
        updateContext.commit();
    }

    static abstract class NodeSpliterator<T, K, E extends EntryNode<K, E>>
    implements Spliterator<T> {
        private Node<K, E>[] array;
        private int pos;
        private int limit;
        private int sizeEstimate;
        private final int characteristics;
        private NodeSpliterator<T, K, E> subSpliterator;

        protected NodeSpliterator(Node<K, E> node, int sizeEstimate, int additionalCharacteristics) {
            if (node instanceof EntryNode) {
                this.array = new Node[]{node};
                this.pos = 0;
                this.limit = 1;
                this.sizeEstimate = 1;
            } else {
                this.array = node.getChildren();
                if (this.array == null) {
                    this.sizeEstimate = 0;
                    this.limit = 0;
                    this.pos = 0;
                } else {
                    this.pos = 0;
                    this.limit = this.array.length;
                    this.sizeEstimate = sizeEstimate;
                }
            }
            this.characteristics = 0x50 | additionalCharacteristics;
        }

        protected NodeSpliterator(Node<K, E>[] array, int pos, int limit, int sizeEstimate, int additionalCharacteristics) {
            this.array = array;
            this.pos = pos;
            this.limit = limit;
            this.sizeEstimate = sizeEstimate;
            this.characteristics = 0x10 | additionalCharacteristics;
        }

        @Override
        public final boolean tryAdvance(Consumer<? super T> action) {
            Node<K, E> node;
            if (this.subSpliterator != null) {
                if (this.subSpliterator.tryAdvance(action)) {
                    return true;
                }
                this.subSpliterator = null;
            }
            if (this.pos >= this.limit) {
                return false;
            }
            if ((node = this.array[this.pos++]) instanceof EntryNode) {
                T value = this.apply((EntryNode)node);
                action.accept(value);
                return true;
            }
            Node<K, E>[] children = node.getChildren();
            this.subSpliterator = this.newSubSpliterator(children, 0, children.length, this.sizeEstimate / (this.limit - this.pos));
            return this.subSpliterator.tryAdvance(action);
        }

        @Override
        public final void forEachRemaining(Consumer<? super T> action) {
            if (this.subSpliterator != null) {
                this.subSpliterator.forEachRemaining(action);
                this.subSpliterator = null;
            }
            this.forEach(this.array, this.pos, this.limit, action);
        }

        private void forEach(Node<K, E>[] nodes, Consumer<? super T> action) {
            this.forEach(nodes, 0, nodes.length, action);
        }

        private void forEach(Node<K, E>[] nodes, int pos, int limit, Consumer<? super T> action) {
            while (pos < limit) {
                if (nodes[pos] != null) {
                    this.forEach(nodes[pos], action);
                }
                ++pos;
            }
        }

        private void forEach(Node<K, E> node, Consumer<? super T> action) {
            if (node instanceof EntryNode) {
                T value = this.apply((EntryNode)node);
                action.accept(value);
            } else {
                Node<K, E>[] children = node.getChildren();
                if (children != null) {
                    this.forEach(children, action);
                }
            }
        }

        private void trim() {
            while (this.pos < this.limit && this.array[this.pos] == null) {
                ++this.pos;
            }
            while (this.limit > this.pos && this.array[this.limit - 1] == null) {
                --this.limit;
            }
        }

        public NodeSpliterator<T, K, E> trySplit() {
            this.trim();
            if (this.subSpliterator != null) {
                return this.trySplitSubSpliterator();
            }
            if (this.pos >= this.limit) {
                return null;
            }
            if (this.pos + 1 == this.limit) {
                return this.trySplitLastNode();
            }
            int mid = this.pos + this.limit >>> 1;
            NodeSpliterator<T, K, E> prefix = this.newSubSpliterator(this.array, this.pos, mid, this.sizeEstimate >>> 1);
            this.pos = mid;
            return prefix;
        }

        private NodeSpliterator<T, K, E> trySplitLastNode() {
            Node<K, E>[] children = this.array[this.pos].getChildren();
            if (children == null) {
                return null;
            }
            this.array = children;
            this.pos = 0;
            this.limit = this.array.length;
            return this.trySplit();
        }

        private NodeSpliterator<T, K, E> trySplitSubSpliterator() {
            Spliterator<T> prefix;
            if (this.pos >= this.limit) {
                prefix = this.subSpliterator.trySplit();
                this.sizeEstimate = this.subSpliterator.sizeEstimate;
            } else {
                prefix = this.subSpliterator;
                this.sizeEstimate -= this.subSpliterator.sizeEstimate;
                this.subSpliterator = null;
            }
            return prefix;
        }

        @Override
        public final long estimateSize() {
            return this.sizeEstimate;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected abstract NodeSpliterator<T, K, E> newSubSpliterator(Node<K, E>[] var1, int var2, int var3, int var4);

        protected abstract T apply(E var1);
    }

    static class ArrayIterator<K, E extends EntryNode<K, E>>
    extends UnmodifiableIterator<E> {
        private final Node<K, E>[][] nodeStack = new Node[7][];
        private final int[] nodeIndices = new int[7];
        private int stackIndex = 0;

        public ArrayIterator(Node<K, E>[] array) {
            this.nodeStack[0] = array;
        }

        public boolean hasNext() {
            while (this.stackIndex >= 0) {
                while (this.nodeIndices[this.stackIndex] < this.nodeStack[this.stackIndex].length) {
                    if (this.nodeStack[this.stackIndex][this.nodeIndices[this.stackIndex]] != null) {
                        return true;
                    }
                    int n = this.stackIndex;
                    this.nodeIndices[n] = this.nodeIndices[n] + 1;
                }
                --this.stackIndex;
            }
            return false;
        }

        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node<K, E> node = this.nodeStack[this.stackIndex][this.nodeIndices[this.stackIndex]];
            int n = this.stackIndex++;
            this.nodeIndices[n] = this.nodeIndices[n] + 1;
            if (node instanceof EntryNode) {
                return (E)((EntryNode)node);
            }
            this.nodeStack[this.stackIndex] = node.getChildren();
            this.nodeIndices[this.stackIndex] = 0;
            return (E)this.next();
        }
    }

    static final class CollisionNode<K, E extends EntryNode<K, E>>
    extends Node<K, E> {
        final int hash;
        private E[] entries;

        public CollisionNode(E first, E second) {
            this.hash = ((EntryNode)first).getHash();
            this.entries = new EntryNode[]{first, second};
        }

        private CollisionNode(EntryNode<? extends K, ? extends E>[] entries) {
            this.hash = entries[0].getHash();
            this.entries = entries;
        }

        @Override
        public E findInternal(int shift, int hash, Object key) {
            for (E entry : this.entries) {
                if (!Objects.equals(((EntryNode)entry).key, key)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public Node<K, E> assocInternal(UpdateContext<? super E> currentContext, int shift, int hash, E newEntry) {
            Node[] nodeArray;
            if (hash == this.hash) {
                for (int i = 0; i < this.entries.length; ++i) {
                    if (Objects.equals(this.entries[i], newEntry)) {
                        return this;
                    }
                    if (!Objects.equals(((EntryNode)this.entries[i]).key, ((EntryNode)newEntry).key)) continue;
                    if (currentContext.merge(this.entries[i], newEntry)) {
                        EntryNode[] newEntries = (EntryNode[])this.entries.clone();
                        newEntries[i] = newEntry;
                        return new CollisionNode<K, E>(newEntries);
                    }
                    return this;
                }
                currentContext.insert(newEntry);
                EntryNode[] newEntries = new EntryNode[this.entries.length + 1];
                System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
                newEntries[this.entries.length] = newEntry;
                return new CollisionNode<K, E>(newEntries);
            }
            if (currentContext.expectedUpdates() == 1) {
                Node[] nodeArray2 = new Node[2];
                nodeArray2[0] = this;
                nodeArray = nodeArray2;
                nodeArray2[1] = null;
            } else {
                Node[] nodeArray3 = new Node[4];
                nodeArray3[0] = this;
                nodeArray3[1] = null;
                nodeArray3[2] = null;
                nodeArray = nodeArray3;
                nodeArray3[3] = null;
            }
            Node[] newChildren = nodeArray;
            HashNode newNode = new HashNode(currentContext, CollisionNode.bit(this.hash, shift), newChildren);
            return ((Node)newNode).assocInternal(currentContext, shift, hash, newEntry);
        }

        @Override
        Node<K, E> dissocInternal(UpdateContext<? super E> currentContext, int shift, int hash, Object key) {
            if (hash == this.hash) {
                for (int i = 0; i < this.entries.length; ++i) {
                    if (!Objects.equals(((EntryNode)this.entries[i]).key, key)) continue;
                    currentContext.delete(this.entries[i]);
                    if (this.entries.length == 2) {
                        if (i == 1) {
                            return this.entries[0];
                        }
                        return this.entries[1];
                    }
                    EntryNode[] newEntries = new EntryNode[this.entries.length - 1];
                    System.arraycopy(this.entries, 0, newEntries, 0, i);
                    if (i + 1 < this.entries.length) {
                        System.arraycopy(this.entries, i + 1, newEntries, i, this.entries.length - i - 1);
                    }
                    return new CollisionNode<K, E>(newEntries);
                }
            }
            return this;
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayIterator((Node<K, E>[])this.entries);
        }

        @Override
        protected Node<K, E>[] getChildren() {
            return this.entries;
        }
    }

    static final class ArrayNode<K, E extends EntryNode<K, E>>
    extends Node<K, E> {
        final UpdateContext<? super E> updateContext;
        private Node<K, E>[] children;
        private int childCount;

        ArrayNode(UpdateContext<? super E> contextReference, Node<K, E>[] children, int childCount) {
            this.updateContext = contextReference;
            this.children = children;
            this.childCount = childCount;
        }

        @Override
        Node<K, E> assocInternal(UpdateContext<? super E> currentContext, int shift, int hash, E newEntry) {
            Object newChild;
            int index = ArrayNode.bitIndex(hash, shift);
            Node<K, E> node = this.children[index];
            int newChildCount = this.childCount;
            if (node != null) {
                newChild = node.assocInternal(currentContext, shift + 5, hash, newEntry);
                if (newChild == node) {
                    return this;
                }
            } else {
                currentContext.insert(newEntry);
                ++newChildCount;
                newChild = newEntry;
            }
            if (this.isEditInPlace(currentContext)) {
                this.children[index] = newChild;
                this.childCount = newChildCount;
                return this;
            }
            Node[] newChildren = (Node[])this.children.clone();
            newChildren[index] = newChild;
            return new ArrayNode<K, E>(currentContext, newChildren, newChildCount);
        }

        @Override
        Node<K, E> dissocInternal(UpdateContext<? super E> currentContext, int shift, int hash, Object key) {
            int index = ArrayNode.bitIndex(hash, shift);
            Node<K, ? super E> node = this.children[index];
            if (node == null) {
                return this;
            }
            int newChildCount = this.childCount;
            Node<K, ? super E> newChild = node.dissocInternal(currentContext, shift + 5, hash, key);
            if (newChild == node) {
                return this;
            }
            if (newChild == null && --newChildCount < 16) {
                return this.toBitmapNode(currentContext, newChildCount, index);
            }
            if (this.isEditInPlace(currentContext)) {
                this.children[index] = newChild;
                this.childCount = newChildCount;
                return this;
            }
            Node[] newChildren = (Node[])this.children.clone();
            newChildren[index] = newChild;
            return new ArrayNode<K, E>(currentContext, newChildren, newChildCount);
        }

        private Node<K, E> toBitmapNode(UpdateContext<? super E> currentContext, int newChildCount, int removedIndex) {
            Node[] newChildren = new Node[newChildCount];
            int bitmap = 0;
            int j = 0;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null || i == removedIndex) continue;
                newChildren[j] = this.children[i];
                bitmap |= 1 << i;
                ++j;
            }
            return new HashNode(currentContext, bitmap, newChildren);
        }

        @Override
        E findInternal(int shift, int hash, Object key) {
            int index = ArrayNode.bitIndex(hash, shift);
            Node<K, E> node = this.children[index];
            if (node != null) {
                return node.findInternal(shift + 5, hash, key);
            }
            return null;
        }

        private boolean isEditInPlace(UpdateContext<? super E> currentContext) {
            return this.updateContext.isSameAs(currentContext);
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayIterator<K, E>(this.children);
        }

        @Override
        public Node<K, E>[] getChildren() {
            return this.children;
        }
    }

    static final class HashNode<K, E extends EntryNode<K, E>>
    extends Node<K, E> {
        final UpdateContext<? super E> updateContext;
        private int bitmap;
        private Node<K, E>[] children;

        HashNode(UpdateContext<? super E> contextReference) {
            this(contextReference, contextReference.expectedUpdates());
        }

        HashNode(UpdateContext<? super E> contextReference, int expectedSize) {
            this(contextReference, 0, new Node[expectedSize < 32 ? expectedSize : 32]);
        }

        HashNode(UpdateContext<? super E> contextReference, int bitmap, Node<K, E>[] children) {
            this.updateContext = contextReference;
            this.bitmap = bitmap;
            this.children = children;
        }

        @Override
        Node<K, E> assocInternal(UpdateContext<? super E> currentContext, int shift, int hash, E newEntry) {
            int bit = HashNode.bit(hash, shift);
            int index = HashNode.index(this.bitmap, bit);
            if ((this.bitmap & bit) != 0) {
                Node<K, E> oldNode = this.children[index];
                Node<K, ? super E> newNode = oldNode.assocInternal(currentContext, shift + 5, hash, newEntry);
                if (newNode == oldNode) {
                    return this;
                }
                HashNode<K, ? super E> editable = this.cloneForReplace(currentContext);
                editable.children[index] = newNode;
                return editable;
            }
            currentContext.insert(newEntry);
            return this.insert(currentContext, index, newEntry, bit);
        }

        @Override
        Node<K, E> dissocInternal(UpdateContext<? super E> currentContext, int shift, int hash, Object key) {
            int bit = HashNode.bit(hash, shift);
            if ((this.bitmap & bit) == 0) {
                return this;
            }
            int index = HashNode.index(this.bitmap, bit);
            Node<K, ? super E> oldNode = this.children[index];
            Node<K, ? super E> newNode = oldNode.dissocInternal(currentContext, shift + 5, hash, key);
            if (newNode == oldNode) {
                return this;
            }
            if (newNode == null) {
                if (this.bitmap == bit) {
                    return null;
                }
                return this.cloneForDelete(currentContext, index, bit);
            }
            HashNode<K, ? super E> editable = this.cloneForReplace(currentContext);
            editable.children[index] = newNode;
            return editable;
        }

        @Override
        public E findInternal(int shift, int hash, Object key) {
            int bit = HashNode.bit(hash, shift);
            if ((this.bitmap & bit) == 0) {
                return null;
            }
            int index = HashNode.index(this.bitmap, bit);
            Node<K, E> nodeOrEntry = this.children[index];
            return nodeOrEntry.findInternal(shift + 5, hash, key);
        }

        private Node<K, E> insert(UpdateContext<? super E> currentContext, int index, E newEntry, int bit) {
            Node[] newChildren;
            int childCount = this.childCount();
            boolean editInPlace = this.updateContext.isSameAs(currentContext);
            if (editInPlace && childCount < this.children.length) {
                newChildren = this.children;
            } else {
                newChildren = new Node[HashNode.newSizeForInsert(currentContext, childCount)];
                if (index > 0) {
                    System.arraycopy(this.children, 0, newChildren, 0, index);
                }
            }
            if (index < childCount) {
                System.arraycopy(this.children, index, newChildren, index + 1, childCount - index);
            }
            newChildren[index] = newEntry;
            if (childCount == 31) {
                return new ArrayNode(currentContext, newChildren, childCount + 1);
            }
            if (editInPlace) {
                this.bitmap |= bit;
                this.children = newChildren;
                return this;
            }
            return new HashNode<K, E>(currentContext, this.bitmap | bit, newChildren);
        }

        private int childCount() {
            return Integer.bitCount(this.bitmap);
        }

        private Node<K, E> cloneForDelete(UpdateContext<? super E> currentContext, int index, int bit) {
            Node<K, E>[] newChildren;
            int childCount = this.childCount();
            boolean editInPlace = this.updateContext.isSameAs(currentContext);
            if (editInPlace) {
                newChildren = this.children;
            } else {
                newChildren = new Node[childCount - 1];
                if (index > 0) {
                    System.arraycopy(this.children, 0, newChildren, 0, index);
                }
            }
            if (index + 1 < childCount) {
                System.arraycopy(this.children, index + 1, newChildren, index, childCount - index - 1);
                if (newChildren.length >= childCount) {
                    newChildren[childCount - 1] = null;
                }
            }
            if (editInPlace) {
                this.bitmap ^= bit;
                return this;
            }
            return new HashNode<K, E>(currentContext, this.bitmap ^ bit, newChildren);
        }

        static int newSizeForInsert(UpdateContext<?> currentContext, int currentChildCount) {
            if (currentContext.expectedUpdates() == 1) {
                return currentChildCount + 1;
            }
            return currentChildCount < 16 ? 2 * (currentChildCount + 1) : 32;
        }

        private HashNode<K, E> cloneForReplace(UpdateContext<? super E> currentContext) {
            if (this.updateContext.isSameAs(currentContext)) {
                return this;
            }
            return new HashNode<K, E>(currentContext, this.bitmap, (Node[])this.children.clone());
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayIterator<K, E>(this.children);
        }

        @Override
        public Node<K, E>[] getChildren() {
            return this.children;
        }
    }

    protected static abstract class EntryNode<K, E extends EntryNode<K, E>>
    extends Node<K, E> {
        final K key;

        public EntryNode(K key) {
            this.key = key;
        }

        public int getHash() {
            return EntryNode.hash(this.key);
        }

        protected E self() {
            return (E)this;
        }

        protected Node<K, E> split(UpdateContext<? super E> currentContext, int shift, int hash, E newEntry) {
            int thisHash = this.getHash();
            if (hash == thisHash) {
                currentContext.insert(newEntry);
                return new CollisionNode(this, (EntryNode)newEntry);
            }
            Node[] newChildren = new Node[HashNode.newSizeForInsert(currentContext, 1)];
            newChildren[0] = this;
            return new HashNode(currentContext, EntryNode.bit(thisHash, shift), newChildren).assocInternal(currentContext, shift, hash, newEntry);
        }

        @Override
        Node<K, E> dissocInternal(UpdateContext<? super E> currentContext, int shift, int hash, Object key) {
            if (Objects.equals(key, this.key)) {
                currentContext.delete(this.self());
                return null;
            }
            return this;
        }

        @Override
        E findInternal(int shift, int hash, Object key) {
            if (Objects.equals(this.key, key)) {
                return this.self();
            }
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.singletonIterator(this.self());
        }

        @Override
        protected Node<K, E>[] getChildren() {
            return null;
        }
    }

    static abstract class Node<K, E extends EntryNode<K, E>>
    implements Iterable<E> {
        static final int SHIFT_INCREMENT = 5;

        Node() {
        }

        E find(Object key) {
            return this.findInternal(0, Node.hash(key), key);
        }

        Node<K, E> assoc(UpdateContext<? super E> currentContext, E newEntry) {
            return this.assocInternal(currentContext, 0, ((EntryNode)newEntry).getHash(), newEntry);
        }

        Node<K, E> dissoc(UpdateContext<? super E> currentContext, Object key) {
            return this.dissocInternal(currentContext, 0, Node.hash(key), key);
        }

        static int hash(Object key) {
            return key == null ? 0 : key.hashCode();
        }

        static int index(int bitmap, int bit) {
            return Integer.bitCount(bitmap & bit - 1);
        }

        static int bit(int hash, int shift) {
            return 1 << Node.bitIndex(hash, shift);
        }

        static int bitIndex(int hash, int shift) {
            return hash >>> shift & 0x1F;
        }

        abstract E findInternal(int var1, int var2, Object var3);

        abstract Node<K, E> assocInternal(UpdateContext<? super E> var1, int var2, int var3, E var4);

        abstract Node<K, E> dissocInternal(UpdateContext<? super E> var1, int var2, int var3, Object var4);

        protected abstract Node<K, E>[] getChildren();
    }
}

