/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.javersion.util.AbstractHashTrie;
import org.javersion.util.MapUtils;
import org.javersion.util.Merger;
import org.javersion.util.UpdateContext;

public abstract class AbstractHashMap<K, V, This extends AbstractHashMap<K, V, This>>
extends AbstractHashTrie<K, EntryNode<K, V>, AbstractHashMap<K, V, This>>
implements Iterable<Map.Entry<K, V>> {
    private static final Function TO_ENTRY = input -> AbstractHashMap.toEntry((Map.Entry)input);

    public This assoc(K key, V value) {
        return this.assoc(new EntryNode<K, V>(key, value));
    }

    private This assoc(Map.Entry<? extends K, ? extends V> entry) {
        return this.merge(entry, null);
    }

    public This assocAll(Map<? extends K, ? extends V> map) {
        return this.mergeAll(map, null);
    }

    public This assocAll(Iterable<Map.Entry<K, V>> entries) {
        return this.mergeAll(entries, null);
    }

    public This merge(K key, V value, Merger<Map.Entry<K, V>> merger) {
        return this.doMerge(new EntryNode<K, V>(key, value), merger);
    }

    public This merge(Map.Entry<? extends K, ? extends V> entry, Merger<Map.Entry<K, V>> merger) {
        return this.doMerge(AbstractHashMap.toEntry(entry), merger);
    }

    protected This doMerge(EntryNode<K, V> entry, Merger<Map.Entry<K, V>> merger) {
        UpdateContext<Map.Entry<K, V>> updateContext = this.updateContext(1, merger);
        return (This)((AbstractHashMap)this.doAdd(updateContext, entry));
    }

    public This mergeAll(Map<? extends K, ? extends V> map, Merger<Map.Entry<K, V>> merger) {
        UpdateContext<Map.Entry<K, V>> updateContext = this.updateContext(map.size(), merger);
        return (This)((AbstractHashMap)this.doAddAll(updateContext, Iterators.transform(map.entrySet().iterator(), (Function)TO_ENTRY)));
    }

    public This mergeAll(Iterable<Map.Entry<K, V>> entries, Merger<Map.Entry<K, V>> merger) {
        UpdateContext<Map.Entry<K, V>> updateContext = this.updateContext(32, merger);
        return (This)((AbstractHashMap)this.doAddAll(updateContext, Iterators.transform(entries.iterator(), (Function)TO_ENTRY)));
    }

    protected UpdateContext<Map.Entry<K, V>> updateContext(int expectedSize, Merger<Map.Entry<K, V>> merger) {
        return new UpdateContext<Map.Entry<K, V>>(expectedSize, merger);
    }

    public This dissoc(Object key) {
        return this.dissoc(key, null);
    }

    public This dissoc(Object key, Merger<Map.Entry<K, V>> merger) {
        UpdateContext<Map.Entry<K, V>> updateContext = this.updateContext(1, merger);
        return (This)((AbstractHashMap)this.doRemove(updateContext, key));
    }

    public V get(Object key) {
        EntryNode entry = (EntryNode)this.root().find(key);
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.root().find(key) != null;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return Iterators.transform(this.doIterator(), Map.Entry.class::cast);
    }

    public Iterable<K> keys() {
        return Iterables.transform((Iterable)this, MapUtils.mapKeyFunction());
    }

    public Iterable<V> values() {
        return Iterables.transform((Iterable)this, MapUtils.mapValueFunction());
    }

    protected static <K, V> EntryNode<K, V> toEntry(Map.Entry<? extends K, ? extends V> entry) {
        if (entry instanceof EntryNode) {
            return (EntryNode)entry;
        }
        return new EntryNode<K, V>(entry.getKey(), entry.getValue());
    }

    static class ValueSpliterator<K, V>
    extends AbstractHashTrie.NodeSpliterator<V, K, EntryNode<K, V>> {
        public ValueSpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>> node, int sizeEstimate, boolean immutable) {
            super(node, sizeEstimate, immutable ? 1024 : 0);
        }

        private ValueSpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>>[] array, int pos, int limit, int sizeEstimate, boolean immutable) {
            super(array, pos, limit, sizeEstimate, immutable ? 1024 : 0);
        }

        @Override
        protected AbstractHashTrie.NodeSpliterator<V, K, EntryNode<K, V>> newSubSpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>>[] array, int pos, int limit, int sizeEstimate) {
            return new ValueSpliterator<K, V>(array, pos, limit, sizeEstimate, this.hasCharacteristics(1024));
        }

        @Override
        protected V apply(EntryNode<K, V> entry) {
            return entry.getValue();
        }
    }

    static class KeySpliterator<K, V>
    extends AbstractHashTrie.NodeSpliterator<K, K, EntryNode<K, V>> {
        public KeySpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>> node, int sizeEstimate, boolean immutable) {
            super(node, sizeEstimate, 1 | (immutable ? 1024 : 0));
        }

        private KeySpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>>[] array, int pos, int limit, int sizeEstimate, boolean immutable) {
            super(array, pos, limit, sizeEstimate, 1 | (immutable ? 1024 : 0));
        }

        @Override
        protected AbstractHashTrie.NodeSpliterator<K, K, EntryNode<K, V>> newSubSpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>>[] array, int pos, int limit, int sizeEstimate) {
            return new KeySpliterator<K, V>(array, pos, limit, sizeEstimate, this.hasCharacteristics(1024));
        }

        @Override
        protected K apply(EntryNode<K, V> entry) {
            return entry.getKey();
        }
    }

    static class EntrySpliterator<K, V>
    extends AbstractHashTrie.NodeSpliterator<Map.Entry<K, V>, K, EntryNode<K, V>> {
        public EntrySpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>> node, int sizeEstimate, boolean immutable) {
            super(node, sizeEstimate, 1 | (immutable ? 1024 : 0));
        }

        private EntrySpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>>[] array, int pos, int limit, int sizeEstimate, boolean immutable) {
            super(array, pos, limit, sizeEstimate, 1 | (immutable ? 1024 : 0));
        }

        @Override
        protected AbstractHashTrie.NodeSpliterator<Map.Entry<K, V>, K, EntryNode<K, V>> newSubSpliterator(AbstractHashTrie.Node<K, EntryNode<K, V>>[] array, int pos, int limit, int sizeEstimate) {
            return new EntrySpliterator<K, V>(array, pos, limit, sizeEstimate, this.hasCharacteristics(1024));
        }

        @Override
        protected Map.Entry<K, V> apply(EntryNode<K, V> entry) {
            return entry;
        }
    }

    public static final class EntryNode<K, V>
    extends AbstractHashTrie.EntryNode<K, EntryNode<K, V>>
    implements Map.Entry<K, V> {
        final V value;

        public EntryNode(K key, V value) {
            super(key);
            this.value = value;
        }

        @Override
        public K getKey() {
            return (K)this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "" + this.key + ": " + this.value;
        }

        @Override
        public AbstractHashTrie.Node<K, EntryNode<K, V>> assocInternal(UpdateContext<? super EntryNode<K, V>> currentContext, int shift, int hash, EntryNode<K, V> newEntry) {
            if (Objects.equals(this.key, newEntry.key)) {
                if (Objects.equals(this.value, newEntry.value)) {
                    return this;
                }
                return currentContext.merge(this, newEntry) ? newEntry : this;
            }
            return this.split(currentContext, shift, hash, newEntry);
        }
    }
}

