/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator.maven;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.javalite.db_migrator.DbUtils;
import org.javalite.db_migrator.Migration;
import org.javalite.db_migrator.MigrationManager;
import org.javalite.db_migrator.maven.AbstractDbMigrationMojo;

public class CheckMojo
extends AbstractDbMigrationMojo {
    @Override
    public void executeMojo() throws MojoExecutionException {
        List<Migration> pendingMigrations;
        this.getLog().info((CharSequence)("Checking " + this.getUrl() + " using migrations from " + this.getMigrationsPath()));
        try {
            this.openConnection();
            MigrationManager manager = new MigrationManager(this.getMigrationsPath());
            pendingMigrations = manager.getPendingMigrations();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to check " + this.getUrl(), e);
        }
        finally {
            DbUtils.closeConnection();
        }
        if (pendingMigrations.isEmpty()) {
            return;
        }
        this.getLog().warn((CharSequence)"Pending migration(s): ");
        for (Migration migration : pendingMigrations) {
            this.getLog().warn((CharSequence)("Migration: " + migration.getName()));
        }
        this.getLog().warn((CharSequence)"Run db-migrator:migrate to apply pending migrations.");
        throw new MojoExecutionException("Pending migration(s) exist, migrate your db and try again.");
    }
}

