/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.javalite.db_migrator.DatabaseType;
import org.javalite.db_migrator.DbUtils;
import org.javalite.db_migrator.Migration;
import org.javalite.db_migrator.MigrationException;
import org.javalite.db_migrator.MigrationResolver;
import org.javalite.db_migrator.VersionStrategy;

public class MigrationManager {
    private DatabaseType dbType;
    private VersionStrategy versionStrategy = new VersionStrategy();
    private MigrationResolver migrationResolver;

    public MigrationManager(String migrationLocation) throws SQLException {
        this.dbType = this.determineDatabaseType();
        this.migrationResolver = new MigrationResolver(migrationLocation);
    }

    public boolean validate() {
        return this.getPendingMigrations().isEmpty();
    }

    public List<Migration> getPendingMigrations() {
        List<String> appliedMigrations = this.getAppliedMigrationVersions();
        List<Migration> allMigrations = this.migrationResolver.resolve();
        ArrayList<Migration> pendingMigrations = new ArrayList<Migration>();
        for (Migration migration : allMigrations) {
            if (appliedMigrations.contains(migration.getVersion())) continue;
            pendingMigrations.add(migration);
        }
        return pendingMigrations;
    }

    public void migrate(Log log, String encoding) {
        this.createSchemaVersionTable();
        List<Migration> pendingMigrations = this.getPendingMigrations();
        if (pendingMigrations.isEmpty()) {
            log.info((CharSequence)"No new migrations are found");
            return;
        }
        log.info((CharSequence)("Migrating database, applying " + pendingMigrations.size() + " migration(s)"));
        Migration currentMigration = null;
        try {
            DbUtils.connection().setAutoCommit(false);
            Iterator iterator = pendingMigrations.iterator();
            while (iterator.hasNext()) {
                Migration migration;
                currentMigration = migration = (Migration)iterator.next();
                log.info((CharSequence)("Running migration " + currentMigration.getName()));
                long start = System.currentTimeMillis();
                currentMigration.migrate(encoding);
                this.versionStrategy.recordMigration(currentMigration.getVersion(), new Date(start), start - System.currentTimeMillis());
                DbUtils.connection().commit();
            }
        }
        catch (Exception e) {
            try {
                DbUtils.connection().rollback();
            }
            catch (Exception ex) {
                throw new MigrationException(e);
            }
            assert (currentMigration != null);
            throw new MigrationException("Migration for version " + currentMigration.getVersion() + " failed, rolling back and terminating migration.", e);
        }
        log.info((CharSequence)"Migrated database");
    }

    protected DatabaseType determineDatabaseType() throws SQLException {
        return DbUtils.databaseType(DbUtils.connection().getMetaData().getURL());
    }

    protected boolean versionTableExists() {
        return this.versionStrategy.versionTableExists();
    }

    public void createSchemaVersionTable() {
        if (!this.versionTableExists()) {
            this.versionStrategy.createSchemaVersionTable(this.dbType);
        }
    }

    protected List<String> getAppliedMigrationVersions() {
        return this.versionStrategy.getAppliedMigrations();
    }
}

