/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.view;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.support.saml.web.view.AbstractSaml10ResponseView;
import org.joda.time.DateTime;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.Subject;

public final class Saml10SuccessResponseView
extends AbstractSaml10ResponseView {
    private static final String VALIDATION_SAML_ATTRIBUTE_NAMESPACE = "http://www.ja-sig.org/products/cas/";
    private static final int DEFAULT_ISSUE_LENGTH = 30000;
    @NotNull
    private String issuer;
    @Min(value=1000L)
    private long issueLength = 30000L;
    @NotNull
    private String rememberMeAttributeName = "longTermAuthenticationRequestTokenUsed";

    @Override
    protected void prepareResponse(Response response, Map<String, Object> model) {
        DateTime issuedAt = response.getIssueInstant();
        Service service = this.getAssertionFrom(model).getService();
        Authentication authentication = this.getPrimaryAuthenticationFrom(model);
        String authenticationMethod = (String)authentication.getAttributes().get("samlAuthenticationStatementAuthMethod");
        AuthenticationStatement authnStatement = this.samlObjectBuilder.newAuthenticationStatement(authentication.getAuthenticationDate(), authenticationMethod, this.getPrincipal(model).getId());
        Assertion assertion = this.samlObjectBuilder.newAssertion(authnStatement, this.issuer, issuedAt, this.samlObjectBuilder.generateSecureRandomId());
        Conditions conditions = this.samlObjectBuilder.newConditions(issuedAt, service.getId(), this.issueLength);
        assertion.setConditions(conditions);
        Subject subject = this.samlObjectBuilder.newSubject(this.getPrincipal(model).getId());
        Map<String, Object> attributesToSend = this.prepareSamlAttributes(model, service);
        if (!attributesToSend.isEmpty()) {
            assertion.getAttributeStatements().add(this.samlObjectBuilder.newAttributeStatement(subject, attributesToSend, VALIDATION_SAML_ATTRIBUTE_NAMESPACE));
        }
        response.setStatus(this.samlObjectBuilder.newStatus(StatusCode.SUCCESS, null));
        response.getAssertions().add(assertion);
    }

    private Map<String, Object> prepareSamlAttributes(Map<String, Object> model, Service service) {
        HashMap<String, String> authnAttributes = new HashMap<String, String>(this.getAuthenticationAttributesAsMultiValuedAttributes(model));
        if (this.isRememberMeAuthentication(model)) {
            authnAttributes.remove("org.jasig.cas.authentication.principal.REMEMBER_ME");
            authnAttributes.put(this.rememberMeAttributeName, Boolean.TRUE.toString());
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        HashMap<String, String> attributesToReturn = new HashMap<String, String>();
        attributesToReturn.putAll(this.getPrincipalAttributesAsMultiValuedAttributes(model));
        attributesToReturn.putAll(authnAttributes);
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attributesToReturn, model, registeredService);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attributesToReturn, model, registeredService);
        Map finalAttributes = this.casAttributeEncoder.encodeAttributes(attributesToReturn, service);
        return finalAttributes;
    }

    public void setIssueLength(long issueLength) {
        this.issueLength = issueLength;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setRememberMeAttributeName(String rememberMeAttributeName) {
        this.rememberMeAttributeName = rememberMeAttributeName;
    }
}

