/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.support;

import java.security.PrivateKey;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.support.saml.authentication.principal.GoogleAccountsService;
import org.jasig.cas.web.support.AbstractArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GoogleAccountsArgumentExtractor
extends AbstractArgumentExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAccountsArgumentExtractor.class);
    @NotNull
    private final PublicKey publicKey;
    @NotNull
    private final PrivateKey privateKey;
    private int skewAllowance;

    public GoogleAccountsArgumentExtractor(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public WebApplicationService extractServiceInternal(HttpServletRequest request) {
        GoogleAccountsService service = GoogleAccountsService.createServiceFrom(request, this.privateKey, this.publicKey);
        if (service != null) {
            service.setSkewAllowance(this.skewAllowance);
        }
        return service;
    }

    @Deprecated
    public void setPrivateKey(PrivateKey privateKey) {
        LOGGER.warn("setPrivateKey() is deprecated and has no effect. Consider using constructors instead.");
    }

    @Deprecated
    public void setPublicKey(PublicKey publicKey) {
        LOGGER.warn("setPublicKey() is deprecated and has no effect. Consider using constructors instead.");
    }

    @Deprecated
    public void setAlternateUsername(String alternateUsername) {
        LOGGER.warn("setAlternateUsername() is deprecated and has no effect. Instead use the configuration in service registry.");
    }

    public void setSkewAllowance(int skewAllowance) {
        this.skewAllowance = skewAllowance;
    }
}

