/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.flow.mdui;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.jasig.cas.support.saml.web.flow.mdui.AbstractMetadataResolverAdapter;
import org.opensaml.saml.metadata.resolver.filter.impl.MetadataFilterChain;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.core.io.Resource;

public final class StaticMetadataResolverAdapter
extends AbstractMetadataResolverAdapter
implements Job {
    private static final int DEFAULT_METADATA_REFRESH_INTERNAL_MINS = 300;
    private int refreshIntervalInMinutes = 300;

    public StaticMetadataResolverAdapter() {
    }

    public StaticMetadataResolverAdapter(Map<Resource, MetadataFilterChain> metadataResources) {
        super(metadataResources);
    }

    public void setRefreshIntervalInMinutes(int refreshIntervalInMinutes) {
        this.refreshIntervalInMinutes = refreshIntervalInMinutes;
    }

    @PostConstruct
    public void refreshMetadata() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                StaticMetadataResolverAdapter.this.buildMetadataResolverAggregate();
            }
        });
        thread.start();
        JobDetail job = JobBuilder.newJob(this.getClass()).withIdentity(this.getClass().getSimpleName()).build();
        Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(this.refreshIntervalInMinutes).repeatForever()).build();
        StdSchedulerFactory schFactory = new StdSchedulerFactory();
        try {
            Scheduler sch = schFactory.getScheduler();
            sch.start();
            sch.scheduleJob(job, trigger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.buildMetadataResolverAggregate();
    }
}

