/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.flow.mdui;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.jasig.cas.services.RegisteredService;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class SimpleMetadataUIInfo
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMetadataUIInfo.class);
    private static final long serialVersionUID = -1434801982864628179L;
    private transient UIInfo uiInfo;
    private final transient RegisteredService registeredService;

    public SimpleMetadataUIInfo(RegisteredService registeredService) {
        this(null, registeredService);
    }

    public SimpleMetadataUIInfo(@Nullable UIInfo uiInfo, RegisteredService registeredService) {
        this.uiInfo = uiInfo;
        this.registeredService = registeredService;
    }

    public String getDescription() {
        Collection<String> items = this.getDescriptions();
        if (items.isEmpty()) {
            return this.registeredService.getDescription();
        }
        return StringUtils.collectionToDelimitedString(items, (String)".");
    }

    public Collection<String> getDescriptions() {
        if (this.uiInfo != null) {
            return this.getStringValues(this.uiInfo.getDescriptions());
        }
        return new ArrayList<String>();
    }

    public String getDisplayName() {
        Collection<String> items = this.getDisplayNames();
        if (items.isEmpty()) {
            return this.registeredService.getName();
        }
        return StringUtils.collectionToDelimitedString(items, (String)".");
    }

    public Collection<String> getDisplayNames() {
        if (this.uiInfo != null) {
            return this.getStringValues(this.uiInfo.getDisplayNames());
        }
        return new ArrayList<String>();
    }

    public String getInformationURL() {
        Collection<String> items = this.getInformationURLs();
        return StringUtils.collectionToDelimitedString(items, (String)".");
    }

    public Collection<String> getInformationURLs() {
        if (this.uiInfo != null) {
            return this.getStringValues(this.uiInfo.getInformationURLs());
        }
        return new ArrayList<String>();
    }

    public String getPrivacyStatementURL() {
        Collection<String> items = this.getPrivacyStatementURLs();
        return StringUtils.collectionToDelimitedString(items, (String)".");
    }

    public Collection<String> getPrivacyStatementURLs() {
        if (this.uiInfo != null) {
            return this.getStringValues(this.uiInfo.getPrivacyStatementURLs());
        }
        return new ArrayList<String>();
    }

    public URL getLogoUrl() {
        try {
            Collection<Logo> items = this.getLogoUrls();
            if (!items.isEmpty()) {
                return new URL(items.iterator().next().getURL());
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return this.registeredService.getLogo();
    }

    public Collection<Logo> getLogoUrls() {
        ArrayList<Logo> list = new ArrayList<Logo>();
        if (this.uiInfo != null) {
            for (Logo d : this.uiInfo.getLogos()) {
                list.add(d);
            }
        }
        return list;
    }

    private Collection<String> getStringValues(List<?> items) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object d : items) {
            if (d instanceof XSURI) {
                list.add(((XSURI)d).getValue());
                continue;
            }
            if (!(d instanceof XSString)) continue;
            list.add(((XSString)d).getValue());
        }
        return list;
    }

    public void setUIInfo(@NotNull UIInfo uiInfo) {
        this.uiInfo = uiInfo;
    }
}

